/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfmentat.tag;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagTypeGenericImplementation;

public class CFMLStartTag
extends StartTagTypeGenericImplementation {
    protected static final String REG_ATTRIBUTES = "(?si)(\\w+)[\\s=]+(((\\x22|\\x27|#)((?!\\4).|\\4{2})*\\4))";
    private static CFMLStartTag INSTANCE = null;

    protected CFMLStartTag(String description, String startDelimiter, String closingDelimiter, EndTagType correspondingEndTagType, boolean isServerTag) {
        super(description, startDelimiter, closingDelimiter, correspondingEndTagType, isServerTag, false, false);
        INSTANCE = this;
    }

    protected CFMLStartTag() {
        super("cf standard tag", "<cf", ">", EndTagType.NORMAL, false, true, false);
    }

    protected CFMLStartTag(String description, String startDelimiter, String closingDelimiter, EndTagType correspondingEndTagType, boolean isServerTag, boolean hasAttributes, boolean isNameAfterPrefixRequired) {
        super(description, startDelimiter, closingDelimiter, correspondingEndTagType, isServerTag, hasAttributes, isNameAfterPrefixRequired);
        INSTANCE = this;
    }

    public static CFMLStartTag getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CFMLStartTag();
        }
        return INSTANCE;
    }

    public boolean atEndOfAttributes(Source source, int pos, boolean isClosingSlashIgnored) {
        ParseText parseText = source.getParseText();
        return parseText.charAt(pos) == '>' || parseText.containsAt("/>", pos);
    }

    protected int getEnd(Source source, int pos) {
        ParseText text = source.getParseText();
        int endStartTagEnd = pos;
        boolean isInQuotes = false;
        boolean isInApos = false;
        block5: for (int x = pos; x < text.length(); ++x) {
            char c = text.charAt(x);
            switch (c) {
                case '>': {
                    if (isInQuotes || isInApos || x > 2 && text.subSequence(x - 3, x).equals("---")) continue block5;
                    return x + 1;
                }
                case '\"': {
                    if (isInApos) continue block5;
                    isInQuotes = !isInQuotes;
                    continue block5;
                }
                case '\'': {
                    if (isInQuotes) continue block5;
                    isInApos = !isInApos;
                    continue block5;
                }
            }
        }
        if (endStartTagEnd >= pos) {
            return endStartTagEnd + 1;
        }
        return endStartTagEnd;
    }

    protected ArrayList getAttributes(String inData) {
        ArrayList<String[]> attributes = new ArrayList<String[]>();
        Pattern pattern = Pattern.compile(REG_ATTRIBUTES, 2);
        Matcher matcher = pattern.matcher(inData);
        if (inData.trim().endsWith("&")) {
            this.userMessage(0, "stripAttributes", "Last attribute cannot be an ampersand", "ERR", null);
        }
        while (matcher.find()) {
            if (matcher.group(1) == null || matcher.group(2) == null) continue;
            String[] attribute = new String[2];
            String attributeName = matcher.group(1).trim();
            String attributeValue = matcher.group(2).trim();
            attributeValue = attributeValue.substring(1, attributeValue.length() - 1);
            attribute[0] = attributeName;
            attribute[1] = attributeValue;
            attributes.add(attribute);
        }
        return attributes;
    }

    private void userMessage(int i, String string, String string2, String string3, Object object) {
    }

    public class AttributeItem {
        public AttributeItem(int linePos, int i, int inputPos, String attrName, String attrValue) {
        }
    }

    public class ParseItemMatch {
    }
}

