/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer.managed;

import com.github.caciocavallosilano.cacio.peer.CacioComponent;
import com.github.caciocavallosilano.cacio.peer.managed.ManagedWindow;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.security.AccessController;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.action.GetPropertyAction;

public class FocusManager {
    private static Logger logger = Logger.getLogger(FocusManager.class.getName());
    private static FocusManager instance;
    private static final Class focusManagerCls;
    private Stack<ManagedWindow> focusedWindowStack = new Stack();

    static FocusManager getInstance() {
        if (instance == null) {
            try {
                instance = (FocusManager)focusManagerCls.newInstance();
            }
            catch (ReflectiveOperationException e) {
                logger.log(Level.SEVERE, "Unable to create FocusManager instance", e);
            }
        }
        return instance.getContextInstance();
    }

    protected FocusManager getContextInstance() {
        return instance;
    }

    ManagedWindow getFocusedWindow() {
        if (this.focusedWindowStack.isEmpty()) {
            return null;
        }
        return (ManagedWindow)this.focusedWindowStack.lastElement();
    }

    void setVisible(ManagedWindow w, boolean v) {
        if (v) {
            this.setFocusedWindow(w);
        } else {
            this.hideWindow(w);
        }
    }

    private void hideWindow(ManagedWindow w) {
        if (this.getFocusedWindow() == w) {
            if (this.focusedWindowStack.size() > 1) {
                ManagedWindow previous = (ManagedWindow)this.focusedWindowStack.get(this.focusedWindowStack.size() - 2);
                this.setFocusedWindow(previous);
            } else {
                this.setFocusedWindow(null);
            }
        }
        this.focusedWindowStack.remove(w);
    }

    void mousePressed(ManagedWindow w) {
        if (w != this.getFocusedWindow()) {
            this.setFocusedWindow(w);
        }
    }

    void setFocusedWindow(ManagedWindow w) {
        if (w != null && (w.getCacioComponent() == null || w.getCacioComponent().isFocusable())) {
            ManagedWindow old = this.getFocusedWindow();
            this.setFocusedWindowNoEvent(w);
            this.focusLost(old, w);
            this.focusGained(w, old);
        }
    }

    void setFocusedWindowNoEvent(ManagedWindow w) {
        if (w == null) {
            this.focusedWindowStack.pop();
        } else {
            this.focusedWindowStack.removeElement(w);
            this.focusedWindowStack.push(w);
        }
    }

    private void focusLost(ManagedWindow w, ManagedWindow lostTo) {
        if (w != null) {
            CacioComponent cacioComp = w.getCacioComponent();
            Component c = cacioComp.getAWTComponent();
            Component opposite = this.getAWTComponent(lostTo);
            FocusEvent fe = new FocusEvent(c, 1005, false, opposite);
            cacioComp.handlePeerEvent(fe);
        }
    }

    private void focusGained(ManagedWindow w, ManagedWindow lost) {
        if (w != null) {
            CacioComponent cacioComp = w.getCacioComponent();
            Component c = cacioComp.getAWTComponent();
            Component opposite = this.getAWTComponent(lost);
            FocusEvent fe = new FocusEvent(c, 1004, false, opposite);
            cacioComp.handlePeerEvent(fe);
        }
    }

    private Component getAWTComponent(ManagedWindow w) {
        Component c;
        if (w != null) {
            CacioComponent cacio = w.getCacioComponent();
            c = cacio.getAWTComponent();
        } else {
            c = null;
        }
        return c;
    }

    static {
        String focusMgrClsName = AccessController.doPrivileged(new GetPropertyAction("cacio.focusmgr"));
        Class cls = FocusManager.class;
        try {
            if (focusMgrClsName != null) {
                cls = Class.forName(focusMgrClsName);
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Unable to load FocusManager implementation", e);
        }
        focusManagerCls = cls;
    }
}

