/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.CacioContainerPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ScrollPane;
import java.awt.peer.ScrollPanePeer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import sun.awt.AWTAccessor;

class CacioScrollPanePeer
extends CacioContainerPeer<ScrollPane, JPanel>
implements ScrollPanePeer {
    private JScrollBar verticalSB;
    private JScrollBar horizontalSB;
    private int childWidth;
    private int childHeight;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;

    CacioScrollPanePeer(ScrollPane awtC, PlatformWindowFactory pwf) {
        super(awtC, pwf);
    }

    @Override
    JPanel initSwingComponent() {
        JPanel jsp = new JPanel();
        this.verticalSB = new JScrollBar(1);
        this.horizontalSB = new JScrollBar(0);
        jsp.add(this.verticalSB);
        jsp.add(this.horizontalSB);
        jsp.setLayout(null);
        return jsp;
    }

    @Override
    public int getHScrollbarHeight() {
        return this.horizontalSB.getHeight();
    }

    @Override
    public int getVScrollbarWidth() {
        return this.verticalSB.getWidth();
    }

    @Override
    public void setScrollPosition(int x, int y) {
        this.verticalSB.setValue(y);
        this.horizontalSB.setValue(x);
    }

    @Override
    public void childResized(int w, int h) {
        this.childWidth = w;
        this.childHeight = h;
        this.verticalSB.setMinimum(0);
        this.verticalSB.setMaximum(w);
        this.horizontalSB.setMinimum(0);
        this.horizontalSB.setMaximum(h);
    }

    @Override
    public void setUnitIncrement(Adjustable arg0, int arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setValue(Adjustable arg0, int arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void layout() {
        this.viewWidth = this.layoutVerticalScrollbar();
        this.viewHeight = this.layoutHorizontalScrollbar();
        ScrollPane sp = (ScrollPane)this.getAWTComponent();
        if (sp.getComponentCount() > 0) {
            Component view = sp.getComponent(0);
            Object peer = AWTAccessor.getComponentAccessor().getPeer(view);
            if (peer instanceof CacioComponentPeer) {
                CacioComponentPeer ccp = (CacioComponentPeer)peer;
                ccp.setViewport(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
            }
        }
        ((JPanel)this.getSwingComponent()).validate();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = null;
        JPanel component = (JPanel)this.getSwingComponent();
        preferredSize = component != null ? ((JPanel)this.getSwingComponent()).getSize() : super.getPreferredSize();
        return preferredSize;
    }

    private int layoutVerticalScrollbar() {
        int vw;
        if (this.needVerticalScrollbar()) {
            this.verticalSB.setVisible(true);
            Dimension vsbSize = this.verticalSB.getPreferredSize();
            Dimension spSize = ((ScrollPane)this.getAWTComponent()).getSize();
            this.verticalSB.setBounds(spSize.width - vsbSize.width, 0, vsbSize.width, spSize.height);
            vw = spSize.width - vsbSize.width;
        } else {
            this.verticalSB.setVisible(false);
            vw = ((ScrollPane)this.getAWTComponent()).getWidth();
        }
        return vw;
    }

    private boolean needVerticalScrollbar() {
        int policy = ((ScrollPane)this.getAWTComponent()).getScrollbarDisplayPolicy();
        return policy == 1 || policy != 2 && this.childHeight > ((ScrollPane)this.getAWTComponent()).getHeight();
    }

    private int layoutHorizontalScrollbar() {
        int vh;
        if (this.needHorizontalScrollbar()) {
            this.horizontalSB.setVisible(true);
            Dimension hsbSize = this.horizontalSB.getPreferredSize();
            Dimension spSize = ((ScrollPane)this.getAWTComponent()).getSize();
            if (this.verticalSB.isVisible()) {
                spSize.width -= this.verticalSB.getWidth();
                int vsbH = this.verticalSB.getHeight() - hsbSize.height;
                this.verticalSB.setSize(new Dimension(this.verticalSB.getWidth(), vsbH));
            }
            this.horizontalSB.setBounds(0, spSize.height - hsbSize.height, spSize.width, hsbSize.height);
            vh = spSize.height - hsbSize.height;
        } else {
            this.verticalSB.setVisible(false);
            vh = ((ScrollPane)this.getAWTComponent()).getHeight();
        }
        return vh;
    }

    private boolean needHorizontalScrollbar() {
        int policy = ((ScrollPane)this.getAWTComponent()).getScrollbarDisplayPolicy();
        return policy == 1 || policy != 2 && this.childWidth > ((ScrollPane)this.getAWTComponent()).getWidth();
    }
}

