/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponent;
import com.github.caciocavallosilano.cacio.peer.CacioKeyboardFocusManagerPeer;
import com.github.caciocavallosilano.cacio.peer.CacioToolkit;
import com.github.caciocavallosilano.cacio.peer.KFMHelper;
import com.github.caciocavallosilano.cacio.peer.PlatformWindow;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import com.github.caciocavallosilano.cacio.peer.ProxyWindow;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.MenuComponentPeer;
import javax.swing.JComponent;
import sun.awt.AWTAccessor;
import sun.awt.ConstrainableGraphics;
import sun.awt.PaintEventDispatcher;
import sun.awt.RepaintArea;
import sun.awt.SunToolkit;
import sun.awt.event.IgnorePaintEvent;
import sun.font.FontDesignMetrics;
import sun.java2d.pipe.Region;

class CacioComponentPeer<AWTComponentType extends Component, SwingComponentType extends JComponent>
implements ComponentPeer,
CacioComponent {
    private AWTComponentType awtComponent;
    private SwingComponentType swingComponent;
    private ProxyWindow proxy;
    PlatformWindow platformWindow;
    private RepaintArea paintArea;
    private Rectangle viewRect;
    private boolean needsClearBackground = false;
    static final int SNFH_FAILURE = 0;
    static final int SNFH_SUCCESS_HANDLED = 1;
    static final int SNFH_SUCCESS_PROCEED = 2;

    CacioComponentPeer(AWTComponentType awtC, PlatformWindowFactory pwf) {
        this.awtComponent = awtC;
        this.init(pwf);
        this.swingComponent = this.initSwingComponent();
        this.initProxy();
        this.postInitSwingComponent();
        this.setBounds(((Component)awtC).getX(), ((Component)awtC).getY(), ((Component)awtC).getWidth(), ((Component)awtC).getHeight(), 2);
        this.paintArea = new RepaintArea(){

            @Override
            protected void updateComponent(Component comp, Graphics g) {
                Graphics2D g2 = CacioComponentPeer.this.getGraphicsImpl();
                g2.setClip(g.getClip());
                CacioComponentPeer.this.peerPaint(g2, true);
                g2.dispose();
                super.updateComponent(comp, g);
            }

            @Override
            protected void paintComponent(Component comp, Graphics g) {
                Graphics2D g2 = CacioComponentPeer.this.getGraphicsImpl();
                g2.setClip(g.getClip());
                CacioComponentPeer.this.peerPaint(g2, false);
                g2.dispose();
                super.paintComponent(comp, g);
            }
        };
    }

    void init(PlatformWindowFactory pwf) {
        PlatformWindow parent = null;
        Container parentComp = ((Component)this.awtComponent).getParent();
        while (parentComp != null && parent == null) {
            if (parentComp.isLightweight()) {
                parentComp = parentComp.getParent();
                continue;
            }
            CacioComponentPeer parentPeer = (CacioComponentPeer)CacioComponentPeer.getPeer(parentComp);
            parent = parentPeer.platformWindow;
        }
        this.platformWindow = pwf.createPlatformWindow(this, parent);
    }

    public static ComponentPeer getPeer(Component component) {
        return AWTAccessor.getComponentAccessor().getPeer(component);
    }

    public static MenuComponentPeer getPeer(MenuComponent component) {
        return AWTAccessor.getMenuComponentAccessor().getPeer(component);
    }

    private void initProxy() {
        if (this.swingComponent != null) {
            this.proxy = new ProxyWindow(this, (JComponent)this.swingComponent);
            this.proxy.setBounds(((Component)this.awtComponent).getX(), ((Component)this.awtComponent).getY(), ((Component)this.awtComponent).getWidth(), ((Component)this.awtComponent).getHeight());
            this.proxy.setVisible(((Component)this.awtComponent).isVisible());
        }
    }

    void postInitSwingComponent() {
        Font font;
        Color fg;
        ((JComponent)this.swingComponent).setOpaque(true);
        Color bg = ((Component)this.awtComponent).getBackground();
        if (bg != null) {
            this.setBackground(bg);
        }
        if ((fg = ((Component)this.awtComponent).getForeground()) != null) {
            this.setForeground(fg);
        }
        if ((font = ((Component)this.awtComponent).getFont()) != null) {
            this.setFont(font);
        }
        boolean enabled = AWTAccessor.getComponentAccessor().isEnabled((Component)this.awtComponent);
        this.setEnabled(enabled);
    }

    SwingComponentType initSwingComponent() {
        return (SwingComponentType)new JComponent(){};
    }

    @Override
    public void dispose() {
        this.platformWindow.dispose();
        if (this.proxy != null) {
            this.proxy.dispose();
        }
        CacioToolkit.disposePeer(this.awtComponent, this);
    }

    @Override
    public ColorModel getColorModel() {
        return this.platformWindow.getColorModel();
    }

    private Graphics2D getGraphicsImpl() {
        Color bg = this.getBackground();
        Color fg = this.getForeground();
        Font font = this.getFont();
        Graphics2D g = this.platformWindow.getGraphics(fg, bg, font);
        if (this.viewRect != null) {
            g.clipRect(this.viewRect.x, this.viewRect.y, this.viewRect.width, this.viewRect.height);
            g.translate(this.viewRect.x, this.viewRect.y);
        }
        return g;
    }

    @Override
    public Graphics getGraphics() {
        Graphics2D g = this.getGraphicsImpl();
        if (this.hasInsets()) {
            Insets i = this.getInsets();
            AWTComponentType c = this.getAWTComponent();
            int w = ((Component)c).getWidth();
            int h = ((Component)c).getHeight();
            ((ConstrainableGraphics)((Object)g)).constrain(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
            g.translate(-i.left, -i.top);
        }
        return g;
    }

    boolean hasInsets() {
        return false;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.platformWindow.getGraphicsConfiguration();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return FontDesignMetrics.getMetrics(font);
    }

    @Override
    public Point getLocationOnScreen() {
        return this.platformWindow.getLocationOnScreen();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension min = this.swingComponent != null ? ((JComponent)this.swingComponent).getMinimumSize() : new Dimension(0, 0);
        return min;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = this.swingComponent != null ? ((JComponent)this.swingComponent).getPreferredSize() : new Dimension(0, 0);
        return pref;
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    @Override
    public void handleEvent(AWTEvent e) {
        switch (e.getID()) {
            case 800: 
            case 801: {
                if (this.isLayouting()) break;
                boolean tmp = this.needsClearBackground;
                this.needsClearBackground = false;
                this.paintArea.paint(this.getAWTComponent(), tmp);
                break;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                this.handleMouseEvent((MouseEvent)e);
                break;
            }
            case 503: 
            case 506: {
                this.handleMouseMotionEvent((MouseEvent)e);
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                this.handleKeyEvent((KeyEvent)e);
                break;
            }
            case 1004: 
            case 1005: {
                this.handleFocusEvent((FocusEvent)e);
                break;
            }
        }
    }

    protected void handleMouseEvent(MouseEvent e) {
        if (this.proxy != null) {
            this.proxy.handleMouseEvent(e);
        }
    }

    protected void handleMouseMotionEvent(MouseEvent e) {
        if (this.proxy != null) {
            this.proxy.handleMouseMotionEvent(e);
        }
    }

    protected void handleKeyEvent(KeyEvent e) {
        if (this.proxy != null) {
            this.proxy.handleKeyEvent(e);
        }
    }

    protected void handleFocusEvent(FocusEvent e) {
        if (this.proxy != null) {
            this.proxy.handleFocusEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void peerPaint(Graphics g, boolean update) {
        Graphics peerG = g.create();
        try {
            if (this.swingComponent != null) {
                SwingComponentType c = this.swingComponent;
                ((JComponent)c).paint(peerG);
            }
        }
        finally {
            peerG.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void peerRepaint(int x, int y, int width, int height) {
        if (EventQueue.isDispatchThread()) {
            Graphics g = ((Component)this.awtComponent).getGraphics();
            try {
                g.clipRect(x, y, width, height);
                this.peerPaint(g, false);
            }
            finally {
                g.dispose();
            }
        } else {
            PaintEvent event = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent((Component)this.awtComponent, 0, 0, ((Component)this.awtComponent).getWidth(), ((Component)this.awtComponent).getHeight());
            ((Component)this.awtComponent).getToolkit().getSystemEventQueue().postEvent(event);
        }
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    @Override
    public boolean isFocusable() {
        boolean ret = this.swingComponent != null ? ((Component)this.swingComponent).isFocusable() : false;
        return ret;
    }

    @Override
    public boolean isReparentSupported() {
        return this.platformWindow.isReparentSuppored();
    }

    @Override
    public void reparent(ContainerPeer newContainer) {
        this.platformWindow.reparent(newContainer);
    }

    @Override
    public void layout() {
    }

    @Override
    public void paint(Graphics g) {
        this.peerPaint(g, true);
    }

    @Override
    public void print(Graphics g) {
        this.peerPaint(g, true);
    }

    @Override
    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, FocusEvent.Cause cause) {
        if (KFMHelper.processSynchronousLightweightTransfer(this.getAWTComponent(), lightweightChild, temporary, focusedWindowChangeAllowed, time)) {
            return true;
        }
        int result = KFMHelper.shouldNativelyFocusHeavyweight(this.getAWTComponent(), lightweightChild, temporary, focusedWindowChangeAllowed, time, cause);
        switch (result) {
            case 0: {
                return false;
            }
            case 2: {
                PlatformWindow pw = this.getPlatformWindow();
                pw.requestFocus();
                return CacioKeyboardFocusManagerPeer.getInstance().requestFocus((Component)this.getAWTComponent(), lightweightChild, temporary, focusedWindowChangeAllowed, time, cause);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setBackground(Color c) {
        ((JComponent)this.swingComponent).setBackground(c);
    }

    Color getBackground() {
        return ((Component)this.swingComponent).getBackground();
    }

    @Override
    public void setFont(Font f) {
        ((JComponent)this.swingComponent).setFont(f);
    }

    Font getFont() {
        return ((Component)this.swingComponent).getFont();
    }

    @Override
    public void setForeground(Color c) {
        ((JComponent)this.swingComponent).setForeground(c);
    }

    Color getForeground() {
        return ((Component)this.swingComponent).getForeground();
    }

    private void setBoundsImpl(int x, int y, int width, int height, int op) {
        this.platformWindow.setBounds(x, y, width, height, op);
    }

    void setViewport(int vx, int vy, int vw, int vh) {
        this.setBoundsImpl(vx, vy, vw, vh, 3);
        this.viewRect = new Rectangle(vx, vy, vw, vh);
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        this.setBoundsImpl(x, y, width, height, op);
        if (this.proxy != null) {
            this.proxy.setBounds(((Component)this.awtComponent).getX(), ((Component)this.awtComponent).getY(), ((Component)this.awtComponent).getWidth(), ((Component)this.awtComponent).getHeight());
        }
        if (this.swingComponent != null) {
            ((Component)this.swingComponent).setBounds(0, 0, width, height);
            ((Container)this.swingComponent).validate();
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.setEnabledImpl(enable);
    }

    void setEnabledImpl(boolean enable) {
        if (this.swingComponent != null) {
            ((JComponent)this.swingComponent).setEnabled(enable);
        }
    }

    boolean isEnabled() {
        return ((Component)this.swingComponent).isEnabled();
    }

    boolean isParentsEnabled() {
        ComponentPeer peer;
        Container parent;
        AWTComponentType c = this.getAWTComponent();
        boolean parentsEnabled = ((Component)c).isEnabled();
        if (parentsEnabled && (parent = ((Component)c).getParent()) != null && (peer = CacioComponentPeer.getPeer(parent)) instanceof CacioComponentPeer) {
            parentsEnabled = ((CacioComponentPeer)peer).isParentsEnabled();
        }
        return parentsEnabled;
    }

    @Override
    public void setVisible(boolean b) {
        this.needsClearBackground = b;
        if (this.proxy != null) {
            this.proxy.setVisible(b);
        }
        this.platformWindow.setVisible(b);
    }

    @Override
    public void updateCursorImmediately() {
    }

    public int checkImage(Image img, int w, int h, ImageObserver o) {
        return Toolkit.getDefaultToolkit().checkImage(img, w, h, o);
    }

    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        return Toolkit.getDefaultToolkit().prepareImage(img, w, h, o);
    }

    public Image createImage(ImageProducer producer) {
        return Toolkit.getDefaultToolkit().createImage(producer);
    }

    @Override
    public Image createImage(int width, int height) {
        return ((CacioToolkit)Toolkit.getDefaultToolkit()).createOffScreenImage((Component)this.awtComponent, width, height);
    }

    @Override
    public VolatileImage createVolatileImage(int width, int height) {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        return gc.createCompatibleVolatileImage(width, height);
    }

    @Override
    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
        this.platformWindow.createBuffers(numBuffers, caps);
    }

    @Override
    public void destroyBuffers() {
        this.platformWindow.destroyBuffers();
    }

    @Override
    public void flip(int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
        this.platformWindow.flip(x1, y1, x2, y2, flipAction);
    }

    @Override
    public Image getBackBuffer() {
        return this.platformWindow.getBackBuffer();
    }

    @Override
    public void coalescePaintEvent(PaintEvent e) {
        if (!(e instanceof IgnorePaintEvent)) {
            this.paintArea.add(e.getUpdateRect(), e.getID());
        }
    }

    @Override
    public void applyShape(Region shape) {
        this.platformWindow.applyShape(shape);
    }

    @Override
    public boolean canDetermineObscurity() {
        return this.platformWindow.canDetermineObscurity();
    }

    @Override
    public boolean isObscured() {
        return this.platformWindow.isObscured();
    }

    @Override
    public PlatformWindow getPlatformWindow() {
        return this.platformWindow;
    }

    public AWTComponentType getAWTComponent() {
        return this.awtComponent;
    }

    @Override
    public void handlePeerEvent(AWTEvent event) {
        this.postEvent(event);
    }

    private void postEvent(AWTEvent event) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(event.getSource()), event);
    }

    public Insets getInsets() {
        return (Insets)this.platformWindow.getInsets().clone();
    }

    SwingComponentType getSwingComponent() {
        return this.swingComponent;
    }

    ProxyWindow getProxyWindow() {
        return this.proxy;
    }

    @Override
    public void setZOrder(ComponentPeer above) {
        System.err.println("CacioComponentPeer::setZOrder: NOT YET IMPLEMENTED");
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration gc) {
        System.err.println("CacioComponentPeer::updateGraphicsData: NOT YET IMPLEMENTED");
        return false;
    }

    RepaintArea getPaintArea() {
        return this.paintArea;
    }

    boolean isLayouting() {
        return false;
    }

    public void clearBackground() {
        this.needsClearBackground = true;
    }
}

