/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.volley;

import android.content.Context;
import android.support.annotation.NonNull;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.bumptech.glide.integration.volley.VolleyRequestFactory;
import com.bumptech.glide.integration.volley.VolleyStreamFetcher;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import java.io.InputStream;

public class VolleyUrlLoader
implements ModelLoader<GlideUrl, InputStream> {
    private final RequestQueue requestQueue;
    private final VolleyRequestFactory requestFactory;

    public VolleyUrlLoader(RequestQueue requestQueue) {
        this(requestQueue, VolleyStreamFetcher.DEFAULT_REQUEST_FACTORY);
    }

    public VolleyUrlLoader(RequestQueue requestQueue, VolleyRequestFactory requestFactory) {
        this.requestQueue = requestQueue;
        this.requestFactory = requestFactory;
    }

    public boolean handles(@NonNull GlideUrl url) {
        return true;
    }

    public ModelLoader.LoadData<InputStream> buildLoadData(@NonNull GlideUrl url, int width, int height, @NonNull Options options) {
        return new ModelLoader.LoadData((Key)url, (DataFetcher)new VolleyStreamFetcher(this.requestQueue, url, this.requestFactory));
    }

    public static class Factory
    implements ModelLoaderFactory<GlideUrl, InputStream> {
        private static volatile RequestQueue internalQueue;
        private final VolleyRequestFactory requestFactory;
        private final RequestQueue requestQueue;

        public Factory(Context context) {
            this(Factory.getInternalQueue(context));
        }

        public Factory(RequestQueue requestQueue) {
            this(requestQueue, VolleyStreamFetcher.DEFAULT_REQUEST_FACTORY);
        }

        public Factory(RequestQueue requestQueue, VolleyRequestFactory requestFactory) {
            this.requestFactory = requestFactory;
            this.requestQueue = requestQueue;
        }

        @NonNull
        public ModelLoader<GlideUrl, InputStream> build(MultiModelLoaderFactory factory) {
            return new VolleyUrlLoader(this.requestQueue, this.requestFactory);
        }

        public void teardown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static RequestQueue getInternalQueue(Context context) {
            if (internalQueue != null) return internalQueue;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (internalQueue != null) return internalQueue;
                internalQueue = Volley.newRequestQueue((Context)context);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return internalQueue;
            }
        }
    }
}

