/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.volley;

import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.bumptech.glide.Priority;
import com.bumptech.glide.integration.volley.VolleyRequestFactory;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

public class VolleyStreamFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "VolleyStreamFetcher";
    public static final VolleyRequestFactory DEFAULT_REQUEST_FACTORY = new VolleyRequestFactory(){

        @Override
        public Request<byte[]> create(String url, DataFetcher.DataCallback<? super InputStream> callback, Request.Priority priority, Map<String, String> headers) {
            return new GlideRequest(url, callback, priority, headers);
        }
    };
    private final RequestQueue requestQueue;
    private final VolleyRequestFactory requestFactory;
    private final GlideUrl url;
    private volatile Request<byte[]> request;

    public VolleyStreamFetcher(RequestQueue requestQueue, GlideUrl url) {
        this(requestQueue, url, DEFAULT_REQUEST_FACTORY);
    }

    public VolleyStreamFetcher(RequestQueue requestQueue, GlideUrl url, VolleyRequestFactory requestFactory) {
        this.requestQueue = requestQueue;
        this.url = url;
        this.requestFactory = requestFactory;
    }

    public void loadData(Priority priority, DataFetcher.DataCallback<? super InputStream> callback) {
        this.request = this.requestFactory.create(this.url.toStringUrl(), callback, VolleyStreamFetcher.glideToVolleyPriority(priority), this.url.getHeaders());
        this.requestQueue.add(this.request);
    }

    public void cleanup() {
    }

    public void cancel() {
        Request<byte[]> local = this.request;
        if (local != null) {
            local.cancel();
        }
    }

    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }

    private static Request.Priority glideToVolleyPriority(Priority priority) {
        switch (priority) {
            case LOW: {
                return Request.Priority.LOW;
            }
            case HIGH: {
                return Request.Priority.HIGH;
            }
            case IMMEDIATE: {
                return Request.Priority.IMMEDIATE;
            }
        }
        return Request.Priority.NORMAL;
    }

    public static class GlideRequest
    extends Request<byte[]> {
        private final DataFetcher.DataCallback<? super InputStream> callback;
        private final Request.Priority priority;
        private final Map<String, String> headers;

        public GlideRequest(String url, DataFetcher.DataCallback<? super InputStream> callback, Request.Priority priority) {
            this(url, callback, priority, Collections.emptyMap());
        }

        public GlideRequest(String url, DataFetcher.DataCallback<? super InputStream> callback, Request.Priority priority, Map<String, String> headers) {
            super(0, url, null);
            this.callback = callback;
            this.priority = priority;
            this.headers = headers;
        }

        public Map<String, String> getHeaders() throws AuthFailureError {
            return this.headers;
        }

        public Request.Priority getPriority() {
            return this.priority;
        }

        protected VolleyError parseNetworkError(VolleyError volleyError) {
            if (Log.isLoggable((String)VolleyStreamFetcher.TAG, (int)3)) {
                Log.d((String)VolleyStreamFetcher.TAG, (String)"Volley failed to retrieve response", (Throwable)volleyError);
            }
            this.callback.onLoadFailed((Exception)volleyError);
            return super.parseNetworkError(volleyError);
        }

        protected Response<byte[]> parseNetworkResponse(NetworkResponse response) {
            this.callback.onDataReady((Object)new ByteArrayInputStream(response.data));
            return Response.success((Object)response.data, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }

        protected void deliverResponse(byte[] response) {
        }
    }
}

