/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.okhttp;

import android.util.Log;
import androidx.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.HttpException;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

@Deprecated
public class OkHttpStreamFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "OkHttpFetcher";
    private final OkHttpClient client;
    private final GlideUrl url;
    InputStream stream;
    ResponseBody responseBody;

    public OkHttpStreamFetcher(OkHttpClient client, GlideUrl url) {
        this.client = client;
        this.url = url;
    }

    public void loadData(@NonNull Priority priority, final @NonNull DataFetcher.DataCallback<? super InputStream> callback) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url.toStringUrl());
        for (Map.Entry headerEntry : this.url.getHeaders().entrySet()) {
            String key = (String)headerEntry.getKey();
            requestBuilder.addHeader(key, (String)headerEntry.getValue());
        }
        Request request = requestBuilder.build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                if (Log.isLoggable((String)OkHttpStreamFetcher.TAG, (int)3)) {
                    Log.d((String)OkHttpStreamFetcher.TAG, (String)"OkHttp failed to obtain result", (Throwable)e);
                }
                callback.onLoadFailed((Exception)e);
            }

            public void onResponse(Response response) throws IOException {
                OkHttpStreamFetcher.this.responseBody = response.body();
                if (response.isSuccessful()) {
                    long contentLength = OkHttpStreamFetcher.this.responseBody.contentLength();
                    OkHttpStreamFetcher.this.stream = ContentLengthInputStream.obtain((InputStream)OkHttpStreamFetcher.this.responseBody.byteStream(), (long)contentLength);
                    callback.onDataReady((Object)OkHttpStreamFetcher.this.stream);
                } else {
                    callback.onLoadFailed((Exception)new HttpException(response.message(), response.code()));
                }
            }
        });
    }

    public void cleanup() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responseBody != null) {
            try {
                this.responseBody.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void cancel() {
    }

    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @NonNull
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }
}

