/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.ksp;

import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.annotation.ksp.GlideSymbolProcessorConstants;
import com.bumptech.glide.annotation.ksp.Index;
import com.bumptech.glide.annotation.ksp.IndexGenerator;
import com.bumptech.glide.annotation.ksp.LibraryGlideModuleData;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0016\u0010\u0011\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\"\u0010\u0012\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/bumptech/glide/annotation/ksp/IndexGenerator;", "", "()V", "INDEXER_NAME_PREFIX", "", "INDEX_MODULES_NAME", "MAXIMUM_FILE_NAME_LENGTH", "", "generate", "Lcom/squareup/kotlinpoet/FileSpec;", "libraryModuleNames", "", "Lcom/bumptech/glide/annotation/ksp/LibraryGlideModuleData$LibraryModuleName;", "generateNameFromLibraryModules", "libraryModuleQualifiedNames", "generateShortUUIDBasedName", "glideModuleBasedName", "generateUniqueName", "addRepeatedMember", "Lcom/squareup/kotlinpoet/AnnotationSpec$Builder;", "name", "repeatedMember", "exceedsFileSystemMaxNameLength", "", "ksp"})
public final class IndexGenerator {
    @NotNull
    public static final IndexGenerator INSTANCE = new IndexGenerator();
    @NotNull
    private static final String INDEXER_NAME_PREFIX = "GlideIndexer_";
    private static final int MAXIMUM_FILE_NAME_LENGTH = 255;
    @NotNull
    public static final String INDEX_MODULES_NAME = "modules";

    private IndexGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FileSpec generate(@NotNull List<LibraryGlideModuleData.LibraryModuleName> libraryModuleNames) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(libraryModuleNames, (String)"libraryModuleNames");
        Iterable $this$map$iv = libraryModuleNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LibraryGlideModuleData.LibraryModuleName libraryModuleName = (LibraryGlideModuleData.LibraryModuleName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getQualifiedName());
        }
        List libraryModuleQualifiedNames = (List)destination$iv$iv;
        AnnotationSpec indexAnnotation = this.addRepeatedMember(AnnotationSpec.Companion.builder(Index.class), INDEX_MODULES_NAME, libraryModuleQualifiedNames).build();
        String indexName = this.generateUniqueName(libraryModuleQualifiedNames);
        return FileSpec.Companion.builder(GlideSymbolProcessorConstants.INSTANCE.getPACKAGE_NAME(), indexName).addType(TypeSpec.Companion.classBuilder(indexName).addAnnotation(indexAnnotation).build()).build();
    }

    private final String generateUniqueName(List<String> libraryModuleQualifiedNames) {
        String glideModuleBasedName = this.generateNameFromLibraryModules(libraryModuleQualifiedNames);
        return this.exceedsFileSystemMaxNameLength(glideModuleBasedName) ? this.generateShortUUIDBasedName(glideModuleBasedName) : glideModuleBasedName;
    }

    private final boolean exceedsFileSystemMaxNameLength(String $this$exceedsFileSystemMaxNameLength) {
        return $this$exceedsFileSystemMaxNameLength.length() >= 255 - INDEXER_NAME_PREFIX.length();
    }

    private final String generateShortUUIDBasedName(String glideModuleBasedName) {
        StringBuilder stringBuilder = new StringBuilder().append(INDEXER_NAME_PREFIX);
        String string = glideModuleBasedName;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string2 = UUID.nameUUIDFromBytes(byArray).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nameUUIDFromBytes(glideM\u2026toByteArray()).toString()");
        return stringBuilder.append(StringsKt.replace$default((String)string2, (String)"-", (String)"_", (boolean)false, (int)4, null)).toString();
    }

    private final String generateNameFromLibraryModules(List<String> libraryModuleQualifiedNames) {
        String string = INDEXER_NAME_PREFIX + GlideModule.class.getSimpleName() + '_';
        return CollectionsKt.joinToString$default((Iterable)libraryModuleQualifiedNames, (CharSequence)"_", (CharSequence)string, null, (int)0, null, (Function1)generateNameFromLibraryModules.1.INSTANCE, (int)28, null);
    }

    private final AnnotationSpec.Builder addRepeatedMember(AnnotationSpec.Builder $this$addRepeatedMember, String name, List<String> repeatedMember) {
        String string = name + " = [\n" + StringsKt.repeat((CharSequence)"%S,\n", (int)repeatedMember.size()) + ']';
        Collection $this$toTypedArray$iv = repeatedMember;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] stringArray2 = stringArray;
        return $this$addRepeatedMember.addMember(string, (Object[])Arrays.copyOf(stringArray2, stringArray2.length));
    }
}

