/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class RequestOptionsExtensionGenerator {
    private TypeName containingClassName;
    private ProcessorUtil processorUtil;

    RequestOptionsExtensionGenerator(TypeName containingClassName, ProcessorUtil processorUtil) {
        this.containingClassName = containingClassName;
        this.processorUtil = processorUtil;
    }

    List<ExecutableElement> getRequestOptionExtensionMethods(Set<String> glideExtensionClassNames) {
        return this.processorUtil.findAnnotatedElementsInClasses(glideExtensionClassNames, GlideOption.class);
    }

    List<MethodSpec> generateInstanceMethodsForExtensions(Set<String> glideExtensionClassNames) {
        List<ExecutableElement> requestOptionExtensionMethods = this.getRequestOptionExtensionMethods(glideExtensionClassNames);
        ArrayList<MethodSpec> result = new ArrayList<MethodSpec>(requestOptionExtensionMethods.size());
        for (ExecutableElement requestOptionsExtensionMethod : requestOptionExtensionMethods) {
            result.add(this.generateMethodsForRequestOptionsExtension(requestOptionsExtensionMethod));
        }
        return result;
    }

    private MethodSpec generateMethodsForRequestOptionsExtension(ExecutableElement element) {
        String extensionRequestOptionsArgument;
        if (element.getReturnType().getKind() == TypeKind.VOID) {
            throw new IllegalArgumentException("The " + String.valueOf(element.getSimpleName()) + " method annotated with @GlideOption in the " + String.valueOf(element.getEnclosingElement().getSimpleName()) + " @GlideExtension is using a legacy format that is no longer supported. Please change your method definition so that your @GlideModule annotated methods return BaseRequestOptions<?> objects instead of null.");
        }
        int overrideType = this.processorUtil.getOverrideType(element);
        String methodName = element.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(element)).varargs(element.isVarArgs()).returns(this.containingClassName).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build());
        List<? extends VariableElement> paramElements = element.getParameters().subList(1, element.getParameters().size());
        List<ParameterSpec> parameters = this.processorUtil.getParameters(paramElements);
        builder.addParameters(parameters);
        if (overrideType == 1) {
            builder.addJavadoc(this.processorUtil.generateSeeMethodJavadoc(this.containingClassName, methodName, paramElements)).addAnnotation(Override.class);
            ArrayList<String> methodArgs = new ArrayList<String>();
            methodArgs.add(element.getSimpleName().toString());
            StringBuilder methodLiterals = new StringBuilder();
            if (!parameters.isEmpty()) {
                for (ParameterSpec parameter : parameters) {
                    methodLiterals.append("$L, ");
                    methodArgs.add(parameter.name);
                }
                methodLiterals = new StringBuilder(methodLiterals.substring(0, methodLiterals.length() - 2));
            }
            extensionRequestOptionsArgument = CodeBlock.builder().add("super.$N(" + String.valueOf(methodLiterals) + ")", methodArgs.toArray(new Object[0])).build().toString();
        } else {
            extensionRequestOptionsArgument = "this";
        }
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder code = new StringBuilder("return ($T) $T.$L($L, ");
        args.add(this.containingClassName);
        args.add(ClassName.get((TypeMirror)element.getEnclosingElement().asType()));
        args.add(element.getSimpleName().toString());
        args.add(extensionRequestOptionsArgument);
        if (!parameters.isEmpty()) {
            for (ParameterSpec parameter : parameters) {
                code.append("$L, ");
                args.add(parameter.name);
            }
        }
        code = new StringBuilder(code.substring(0, code.length() - 2));
        code.append(")");
        builder.addStatement(code.toString(), args.toArray(new Object[0]));
        builder.addAnnotation(this.processorUtil.checkResult()).addAnnotation(this.processorUtil.nonNull());
        return builder.build();
    }
}

