/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.repackaged.com.google.common.base;

import com.bumptech.glide.repackaged.com.google.common.base.Joiner;
import com.bumptech.glide.repackaged.com.google.common.base.Predicate;
import java.io.Serializable;

public final class Predicates {
    private static final Joiner COMMA_JOINER = Joiner.on(',');

    public static <T> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> notNull() {
        return ObjectPredicate.NOT_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> equalTo(T target) {
        return target == null ? Predicates.isNull() : new IsEqualToPredicate(target);
    }

    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;

        private IsEqualToPredicate(T target) {
            this.target = target;
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public String toString() {
            return "Predicates.equalTo(" + this.target + ")";
        }
    }

    static abstract class ObjectPredicate
    extends Enum<ObjectPredicate>
    implements Predicate<Object> {
        public static final /* enum */ ObjectPredicate ALWAYS_TRUE = new ObjectPredicate(){

            @Override
            public boolean apply(Object o) {
                return true;
            }

            public String toString() {
                return "Predicates.alwaysTrue()";
            }
        };
        public static final /* enum */ ObjectPredicate ALWAYS_FALSE = new ObjectPredicate(){

            @Override
            public boolean apply(Object o) {
                return false;
            }

            public String toString() {
                return "Predicates.alwaysFalse()";
            }
        };
        public static final /* enum */ ObjectPredicate IS_NULL = new ObjectPredicate(){

            @Override
            public boolean apply(Object o) {
                return o == null;
            }

            public String toString() {
                return "Predicates.isNull()";
            }
        };
        public static final /* enum */ ObjectPredicate NOT_NULL = new ObjectPredicate(){

            @Override
            public boolean apply(Object o) {
                return o != null;
            }

            public String toString() {
                return "Predicates.notNull()";
            }
        };
        private static final /* synthetic */ ObjectPredicate[] $VALUES;

        <T> Predicate<T> withNarrowedType() {
            return this;
        }

        static {
            $VALUES = new ObjectPredicate[]{ALWAYS_TRUE, ALWAYS_FALSE, IS_NULL, NOT_NULL};
        }
    }
}

