/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import com.github.blutorange.maven.plugin.closurecompiler.common.FileMessage;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.JSError;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class ClosureCompileFileMessage
extends FileMessage {
    private ClosureCompileFileMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        super(file, line, column, message, severity, cause);
    }

    private static FileMessage of(JSError error, Compiler compiler, File baseDir, int severity) {
        String message = ClosureCompileFileMessage.format(compiler, error, severity, false);
        File file = StringUtils.isNotEmpty((CharSequence)error.getSourceName()) ? new File(baseDir, error.getSourceName()) : baseDir;
        return new ClosureCompileFileMessage(file, error.getLineNumber(), error.getCharno(), message, severity, null);
    }

    public static FileMessage ofError(JSError error, Compiler compiler, File baseDir) {
        return ClosureCompileFileMessage.of(error, compiler, baseDir, 2);
    }

    public static FileMessage ofWarning(JSError error, Compiler compiler, File baseDir) {
        return ClosureCompileFileMessage.of(error, compiler, baseDir, 1);
    }

    private static String format(Compiler source, JSError error, int severity, boolean includeLocation) {
        String sourceName = error.getSourceName();
        int lineNumber = error.getLineNumber();
        StringBuilder b = new StringBuilder();
        StringBuilder boldLine = new StringBuilder();
        String nonMappedPosition = ClosureCompileFileMessage.formatPosition(sourceName, lineNumber);
        if (includeLocation) {
            Mapping.OriginalMapping mapping;
            Mapping.OriginalMapping originalMapping = mapping = source == null ? null : source.getSourceMapping(error.getSourceName(), error.getLineNumber(), error.getCharno());
            if (mapping == null) {
                boldLine.append(nonMappedPosition);
            } else {
                sourceName = mapping.getOriginalFile();
                lineNumber = mapping.getLineNumber();
                b.append(nonMappedPosition);
                b.append("\nOriginally at:\n");
                boldLine.append(ClosureCompileFileMessage.formatPosition(sourceName, lineNumber));
            }
        }
        boldLine.append(severity == 1 ? "WARNING" : "ERROR");
        boldLine.append(" - ");
        boldLine.append(error.getDescription());
        b.append(boldLine.toString());
        b.append('\n');
        return b.toString();
    }

    private static String formatPosition(String sourceName, int lineNumber) {
        StringBuilder b = new StringBuilder();
        if (sourceName != null) {
            b.append(sourceName);
            if (lineNumber > 0) {
                b.append(':');
                b.append(lineNumber);
            }
            b.append(": ");
        }
        return b.toString();
    }
}

