/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jodd.util.ClassUtil;

public class ResourcesUtils {
    public static URL getResourceUrl(String resourceName, ClassLoader classLoader) {
        URL resourceUrl;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (classLoader != null && (resourceUrl = classLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader && (resourceUrl = currentThreadClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        Class callerClass = ClassUtil.getCallerClass((int)2);
        ClassLoader callerClassLoader = callerClass.getClassLoader();
        if (callerClassLoader != classLoader && callerClassLoader != currentThreadClassLoader) {
            resourceUrl = callerClassLoader.getResource(resourceName);
            return resourceUrl;
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return ResourcesUtils.getResourceAsStream(resourceName, null);
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass) throws IOException {
        URL url = ResourcesUtils.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }
}

