/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.util;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.util.XmlConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);
    private static final List<String> NO_SIGN_PARAMS = Lists.newArrayList((Object[])new String[]{"sign", "key", "xmlString", "xmlDoc", "couponList"});

    @Deprecated
    public static String createSign(Object xmlBean, String signKey) {
        return SignUtils.createSign(SignUtils.xmlBean2Map(xmlBean), signKey);
    }

    @Deprecated
    public static String createSign(Map<String, String> params, String signKey) {
        return SignUtils.createSign(params, "MD5", signKey, new String[0]);
    }

    public static String createSign(Object xmlBean, String signType, String signKey, String[] ignoredParams) {
        Map<String, String> map = null;
        if (XmlConfig.fastMode && xmlBean instanceof BaseWxPayRequest) {
            map = ((BaseWxPayRequest)xmlBean).getSignParams();
        }
        if (map == null) {
            map = SignUtils.xmlBean2Map(xmlBean);
        }
        return SignUtils.createSign(map, signType, signKey, ignoredParams);
    }

    public static String createSign(Map<String, String> params, String signType, String signKey, String[] ignoredParams) {
        StringBuilder toSign = new StringBuilder();
        for (String key : new TreeMap<String, String>(params).keySet()) {
            String value = params.get(key);
            boolean shouldSign = false;
            if (StringUtils.isNotEmpty((CharSequence)value) && !ArrayUtils.contains((Object[])ignoredParams, (Object)key) && !NO_SIGN_PARAMS.contains(key)) {
                shouldSign = true;
            }
            if (!shouldSign) continue;
            toSign.append(key).append("=").append(value).append("&");
        }
        toSign.append("key=").append(signKey);
        if ("HMAC-SHA256".equals(signType)) {
            return me.chanjar.weixin.common.util.SignUtils.createHmacSha256Sign((String)toSign.toString(), (String)signKey);
        }
        return DigestUtils.md5Hex((String)toSign.toString()).toUpperCase();
    }

    public static String createEntSign(String actName, String mchBillNo, String mchId, String nonceStr, String reOpenid, Integer totalAmount, String wxAppId, String signKey, String signType) {
        HashMap<String, String> sortedMap = new HashMap<String, String>(8);
        sortedMap.put("act_name", actName);
        sortedMap.put("mch_billno", mchBillNo);
        sortedMap.put("mch_id", mchId);
        sortedMap.put("nonce_str", nonceStr);
        sortedMap.put("re_openid", reOpenid);
        sortedMap.put("total_amount", totalAmount + "");
        sortedMap.put("wxappid", wxAppId);
        return SignUtils.toSignBuilder(sortedMap, signKey, signType);
    }

    public static String createEntSign(Integer totalAmount, String appId, String description, String mchId, String nonceStr, String openid, String partnerTradeNo, String wwMsgType, String signKey, String signType) {
        HashMap<String, String> sortedMap = new HashMap<String, String>(8);
        sortedMap.put("amount", String.valueOf(totalAmount));
        sortedMap.put("appid", appId);
        sortedMap.put("desc", description);
        sortedMap.put("mch_id", mchId);
        sortedMap.put("nonce_str", nonceStr);
        sortedMap.put("openid", openid);
        sortedMap.put("partner_trade_no", partnerTradeNo);
        sortedMap.put("ww_msg_type", wwMsgType);
        return SignUtils.toSignBuilder(sortedMap, signKey, signType);
    }

    private static String toSignBuilder(Map<String, String> sortedMap, String signKey, String signType) {
        Iterator<Map.Entry<String, String>> iterator = new TreeMap<String, String>(sortedMap).entrySet().iterator();
        StringBuilder toSign = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String value = entry.getValue();
            boolean shouldSign = false;
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                shouldSign = true;
            }
            if (!shouldSign) continue;
            toSign.append(entry.getKey()).append("=").append(value).append("&");
        }
        toSign.append("secret=").append(signKey);
        if ("HMAC-SHA256".equals(signType)) {
            return me.chanjar.weixin.common.util.SignUtils.createHmacSha256Sign((String)toSign.toString(), (String)signKey);
        }
        return DigestUtils.md5Hex((String)toSign.toString()).toUpperCase();
    }

    public static boolean checkSign(Object xmlBean, String signType, String signKey) {
        return SignUtils.checkSign(SignUtils.xmlBean2Map(xmlBean), signType, signKey);
    }

    public static boolean checkSign(Map<String, String> params, String signType, String signKey) {
        String sign = SignUtils.createSign(params, signType, signKey, new String[0]);
        return sign.equals(params.get("sign"));
    }

    public static Map<String, String> xmlBean2Map(Object bean) {
        HashMap result = Maps.newHashMap();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(bean.getClass().getDeclaredFields()));
        fields.addAll(Arrays.asList(bean.getClass().getSuperclass().getDeclaredFields()));
        if (bean.getClass().getSuperclass().getSuperclass() == BaseWxPayRequest.class) {
            fields.addAll(Arrays.asList(BaseWxPayRequest.class.getDeclaredFields()));
        }
        if (bean.getClass().getSuperclass().getSuperclass() == BaseWxPayResult.class) {
            fields.addAll(Arrays.asList(BaseWxPayResult.class.getDeclaredFields()));
        }
        for (Field field : fields) {
            try {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                if (field.get(bean) == null) {
                    field.setAccessible(isAccessible);
                    continue;
                }
                if (field.isAnnotationPresent(XStreamAlias.class)) {
                    result.put(field.getAnnotation(XStreamAlias.class).value(), field.get(bean).toString());
                } else if (!Modifier.isStatic(field.getModifiers())) {
                    result.put(field.getName(), field.get(bean).toString());
                }
                field.setAccessible(isAccessible);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

