/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.bean;

public class WxMpHostConfig {
    public static final String API_DEFAULT_HOST_URL = "https://api.weixin.qq.com";
    public static final String MP_DEFAULT_HOST_URL = "https://mp.weixin.qq.com";
    public static final String OPEN_DEFAULT_HOST_URL = "https://open.weixin.qq.com";
    private String apiHost;
    private String openHost;
    private String mpHost;

    public static String buildUrl(WxMpHostConfig hostConfig, String prefix, String path) {
        if (hostConfig == null) {
            return prefix + path;
        }
        if (hostConfig.getApiHost() != null && prefix.equals(API_DEFAULT_HOST_URL)) {
            return hostConfig.getApiHost() + path;
        }
        if (hostConfig.getMpHost() != null && prefix.equals(MP_DEFAULT_HOST_URL)) {
            return hostConfig.getMpHost() + path;
        }
        if (hostConfig.getOpenHost() != null && prefix.equals(OPEN_DEFAULT_HOST_URL)) {
            return hostConfig.getOpenHost() + path;
        }
        return prefix + path;
    }

    public static WxMpHostConfigBuilder builder() {
        return new WxMpHostConfigBuilder();
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public String getOpenHost() {
        return this.openHost;
    }

    public String getMpHost() {
        return this.mpHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public void setOpenHost(String openHost) {
        this.openHost = openHost;
    }

    public void setMpHost(String mpHost) {
        this.mpHost = mpHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMpHostConfig)) {
            return false;
        }
        WxMpHostConfig other = (WxMpHostConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiHost = this.getApiHost();
        String other$apiHost = other.getApiHost();
        if (this$apiHost == null ? other$apiHost != null : !this$apiHost.equals(other$apiHost)) {
            return false;
        }
        String this$openHost = this.getOpenHost();
        String other$openHost = other.getOpenHost();
        if (this$openHost == null ? other$openHost != null : !this$openHost.equals(other$openHost)) {
            return false;
        }
        String this$mpHost = this.getMpHost();
        String other$mpHost = other.getMpHost();
        return !(this$mpHost == null ? other$mpHost != null : !this$mpHost.equals(other$mpHost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxMpHostConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiHost = this.getApiHost();
        result = result * 59 + ($apiHost == null ? 43 : $apiHost.hashCode());
        String $openHost = this.getOpenHost();
        result = result * 59 + ($openHost == null ? 43 : $openHost.hashCode());
        String $mpHost = this.getMpHost();
        result = result * 59 + ($mpHost == null ? 43 : $mpHost.hashCode());
        return result;
    }

    public String toString() {
        return "WxMpHostConfig(apiHost=" + this.getApiHost() + ", openHost=" + this.getOpenHost() + ", mpHost=" + this.getMpHost() + ")";
    }

    public WxMpHostConfig() {
    }

    public WxMpHostConfig(String apiHost, String openHost, String mpHost) {
        this.apiHost = apiHost;
        this.openHost = openHost;
        this.mpHost = mpHost;
    }

    public static class WxMpHostConfigBuilder {
        private String apiHost;
        private String openHost;
        private String mpHost;

        WxMpHostConfigBuilder() {
        }

        public WxMpHostConfigBuilder apiHost(String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public WxMpHostConfigBuilder openHost(String openHost) {
            this.openHost = openHost;
            return this;
        }

        public WxMpHostConfigBuilder mpHost(String mpHost) {
            this.mpHost = mpHost;
            return this;
        }

        public WxMpHostConfig build() {
            return new WxMpHostConfig(this.apiHost, this.openHost, this.mpHost);
        }

        public String toString() {
            return "WxMpHostConfig.WxMpHostConfigBuilder(apiHost=" + this.apiHost + ", openHost=" + this.openHost + ", mpHost=" + this.mpHost + ")";
        }
    }
}

