/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.okhttp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.UUID;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import me.chanjar.weixin.mp.util.http.QrCodeRequestExecutor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkhttpQrCodeRequestExecutor
extends QrCodeRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public OkhttpQrCodeRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public File execute(String uri, WxMpQrCodeTicket ticket) throws WxErrorException, IOException {
        Request request;
        OkHttpClient client;
        Response response;
        String contentTypeHeader;
        this.logger.debug("OkhttpQrCodeRequestExecutor is running");
        if (ticket != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? "ticket=" + URLEncoder.encode(ticket.getTicket(), "UTF-8") : "&ticket=" + URLEncoder.encode(ticket.getTicket(), "UTF-8"));
        }
        if ("text/plain".equals(contentTypeHeader = (response = (client = (OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request = new Request.Builder().url(uri).get().build()).execute()).header("Content-Type"))) {
            String responseContent = response.body().string();
            throw new WxErrorException(WxError.fromJson((String)responseContent));
        }
        try (InputStream inputStream = response.body().byteStream();){
            File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
            return file;
        }
    }
}

