/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.bean.xpay;

import java.io.Serializable;
import me.chanjar.weixin.common.util.SignUtils;
import org.apache.commons.lang3.StringUtils;

public class WxMaXPaySigParams
implements Serializable {
    private static final long serialVersionUID = 7495157056049312108L;
    private String sessionKey;
    private String appKey;

    public String signUriWithBoth(String url, String postData) {
        String sig = this.calcSig(postData);
        String paySig = this.calcPaySig(url, postData);
        return String.format(url, paySig, sig);
    }

    public String signUriWithPay(String url, String postData) {
        String paySig = this.calcPaySig(url, postData);
        return String.format(url, paySig);
    }

    public String signUriWithUser(String url, String postData) {
        String sig = this.calcSig(postData);
        String uri = String.format(url, sig);
        return uri;
    }

    protected String convUrlToSigUri(String url) {
        if (url == null) {
            return "";
        }
        String t = url.replace("https://api.weixin.qq.com", "");
        if (t.contains("?")) {
            t = t.substring(0, t.indexOf("?"));
        }
        return t;
    }

    public String calcPaySig(String url, String postBody) {
        String ak = StringUtils.trimToEmpty((String)this.appKey);
        String sigUri = this.convUrlToSigUri(url);
        String paySig = this.calcPaySignature(sigUri, postBody, ak);
        return paySig.toLowerCase();
    }

    public String calcSig(String postBody) {
        String sk = StringUtils.trimToEmpty((String)this.sessionKey);
        return this.calcSignature(postBody, sk);
    }

    protected String calcSignature(String postBody, String sessionKey) {
        return SignUtils.createHmacSha256Sign((String)postBody, (String)sessionKey);
    }

    protected String calcPaySignature(String uri, String postBody, String appKey) {
        String needSignData = uri + '&' + postBody;
        return SignUtils.createHmacSha256Sign((String)needSignData, (String)appKey);
    }

    public static WxMaXPaySigParamsBuilder builder() {
        return new WxMaXPaySigParamsBuilder();
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMaXPaySigParams)) {
            return false;
        }
        WxMaXPaySigParams other = (WxMaXPaySigParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sessionKey = this.getSessionKey();
        String other$sessionKey = other.getSessionKey();
        if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
            return false;
        }
        String this$appKey = this.getAppKey();
        String other$appKey = other.getAppKey();
        return !(this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxMaXPaySigParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sessionKey = this.getSessionKey();
        result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
        String $appKey = this.getAppKey();
        result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
        return result;
    }

    public String toString() {
        return "WxMaXPaySigParams(sessionKey=" + this.getSessionKey() + ", appKey=" + this.getAppKey() + ")";
    }

    public WxMaXPaySigParams() {
    }

    public WxMaXPaySigParams(String sessionKey, String appKey) {
        this.sessionKey = sessionKey;
        this.appKey = appKey;
    }

    public static class WxMaXPaySigParamsBuilder {
        private String sessionKey;
        private String appKey;

        WxMaXPaySigParamsBuilder() {
        }

        public WxMaXPaySigParamsBuilder sessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
            return this;
        }

        public WxMaXPaySigParamsBuilder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public WxMaXPaySigParams build() {
            return new WxMaXPaySigParams(this.sessionKey, this.appKey);
        }

        public String toString() {
            return "WxMaXPaySigParams.WxMaXPaySigParamsBuilder(sessionKey=" + this.sessionKey + ", appKey=" + this.appKey + ")";
        }
    }
}

