/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.corpgroup.service.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxCpErrorMsgEnum;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.corpgroup.WxCpCorpGroupCorpGetTokenReq;
import me.chanjar.weixin.cp.bean.corpgroup.WxCpMaTransferSession;
import me.chanjar.weixin.cp.config.WxCpCorpGroupConfigStorage;
import me.chanjar.weixin.cp.corpgroup.service.WxCpCgService;
import me.chanjar.weixin.cp.corpgroup.service.WxCpLinkedCorpService;
import me.chanjar.weixin.cp.corpgroup.service.impl.WxCpLinkedCorpServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxCpCgServiceImpl<H, P>
implements WxCpCgService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxCpCgServiceImpl.class);
    WxCpService wxCpService;
    protected WxCpCorpGroupConfigStorage configStorage;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;
    private final WxCpLinkedCorpService linkedCorpService = new WxCpLinkedCorpServiceImpl(this);

    @Override
    public void updateCorpAccessToken(String corpId, Integer agentId, String corpAccessToken, int expiresInSeconds) {
    }

    @Override
    public String getCorpAccessToken(String corpId, Integer agentId, Integer businessType) throws WxErrorException {
        return this.getCorpAccessToken(corpId, agentId, businessType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCorpAccessToken(String corpId, Integer agentId, Integer businessType, boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isCorpAccessTokenExpired(corpId, agentId) && !forceRefresh) {
            return this.configStorage.getCorpAccessToken(corpId, agentId);
        }
        BaseWxCpCgServiceImpl baseWxCpCgServiceImpl = this;
        synchronized (baseWxCpCgServiceImpl) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("corpid", corpId);
            jsonObject.addProperty("agentid", (Number)agentId);
            jsonObject.addProperty("business_type", (Number)businessType);
            String url = this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/corpgroup/corp/gettoken");
            String responseContent = this.wxCpService.post(url, jsonObject);
            WxAccessToken corpToken = WxAccessToken.fromJson((String)responseContent);
            this.configStorage.updateCorpAccessToken(corpId, agentId, corpToken.getAccessToken(), corpToken.getExpiresIn());
        }
        return this.configStorage.getCorpAccessToken(corpId, agentId);
    }

    @Override
    public WxAccessToken getCorpAccessTokenEntity(String corpId, Integer agentId, Integer businessType) throws WxErrorException {
        return this.getCorpAccessTokenEntity(corpId, agentId, businessType, false);
    }

    @Override
    public WxAccessToken getCorpAccessTokenEntity(String corpId, Integer agentId, Integer businessType, boolean forceRefresh) throws WxErrorException {
        return this.configStorage.getCorpAccessTokenEntity(corpId, agentId);
    }

    @Override
    public boolean isCorpAccessTokenExpired(String corpId, Integer agentId) {
        return this.configStorage.isCorpAccessTokenExpired(corpId, agentId);
    }

    @Override
    public void expireCorpAccessToken(String corpId, Integer agentId) {
        this.configStorage.expireCorpAccessToken(corpId, agentId);
    }

    @Override
    public String get(String url, String queryParam, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam, req);
    }

    @Override
    public String get(String url, String queryParam, boolean withoutCorpAccessToken, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam, withoutCorpAccessToken, req);
    }

    @Override
    public String post(String url, String postData, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData, false, req);
    }

    public String post(String url, String postData, boolean withoutCorpAccessToken, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData, withoutCorpAccessToken, req);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        return this.execute(executor, uri, data, false, req);
    }

    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data, boolean withoutCorpAccessToken, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data, withoutCorpAccessToken, req);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        return this.executeInternal(executor, uri, data, false, req);
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data, boolean withoutCorpAccessToken, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        String uriWithAccessToken;
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        if (!withoutCorpAccessToken) {
            String corpAccessToken = this.getCorpAccessToken(req.getCorpId(), req.getAgentId(), req.getBusinessType());
            uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + corpAccessToken;
        } else {
            uriWithAccessToken = uri;
        }
        try {
            Object result = executor.execute(uriWithAccessToken, data, WxType.CP);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == WxCpErrorMsgEnum.CODE_42009.getCode()) {
                this.configStorage.expireCorpAccessToken(req.getCorpId(), req.getAgentId());
                if (this.getWxCpCorpGroupConfigStorage().autoRefreshToken()) {
                    log.warn("\u5373\u5c06\u91cd\u65b0\u83b7\u53d6\u65b0\u7684access_token\uff0c\u9519\u8bef\u4ee3\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)error.getErrorCode(), (Object)error.getErrorMsg());
                    return this.execute(executor, uri, data, req);
                }
            }
            if (error.getErrorCode() != 0) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new WxRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setWxCpCorpGroupConfigStorage(WxCpCorpGroupConfigStorage wxCpCorpGroupConfigStorage) {
        this.configStorage = wxCpCorpGroupConfigStorage;
        this.initHttp();
    }

    @Override
    public WxCpCorpGroupConfigStorage getWxCpCorpGroupConfigStorage() {
        return this.configStorage;
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public RequestHttp<?, ?> getRequestHttp() {
        return this;
    }

    @Override
    public void setWxCpService(WxCpService wxCpService) {
        this.wxCpService = wxCpService;
    }

    @Override
    public WxCpLinkedCorpService getLinkedCorpService() {
        return this.linkedCorpService;
    }

    @Override
    public WxCpMaTransferSession getCorpTransferSession(String userId, String sessionKey, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        String url = this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/miniprogram/transfer_session");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("session_key", sessionKey);
        String result = this.post(url, jsonObject.toString(), req);
        return WxCpMaTransferSession.fromJson(result);
    }
}

