/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpExportService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.export.WxCpExportRequest;
import me.chanjar.weixin.cp.bean.export.WxCpExportResult;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpExportServiceImpl
implements WxCpExportService {
    private final WxCpService mainService;

    @Override
    public String simpleUser(WxCpExportRequest params) throws WxErrorException {
        return this.export("/cgi-bin/export/simple_user", params);
    }

    @Override
    public String user(WxCpExportRequest params) throws WxErrorException {
        return this.export("/cgi-bin/export/user", params);
    }

    @Override
    public String department(WxCpExportRequest params) throws WxErrorException {
        return this.export("/cgi-bin/export/department", params);
    }

    @Override
    public String tagUser(WxCpExportRequest params) throws WxErrorException {
        return this.export("/cgi-bin/export/taguser", params);
    }

    @Override
    public WxCpExportResult getResult(String jobId) throws WxErrorException {
        String url = String.format(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/export/get_result?jobid=%s"), jobId);
        String responseContent = this.mainService.get(url, null);
        return (WxCpExportResult)WxCpGsonBuilder.create().fromJson(responseContent, WxCpExportResult.class);
    }

    private String export(String path, WxCpExportRequest params) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl(path);
        String responseContent = this.mainService.post(url, params.toJson());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("jobid").getAsString();
    }

    public WxCpExportServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

