/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.io.IOException;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpSimplePostRequestExecutor
extends SimplePostRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private static final Logger log = LoggerFactory.getLogger(OkHttpSimplePostRequestExecutor.class);

    public OkHttpSimplePostRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    @Override
    public String execute(String uri, String postEntity, WxType wxType) throws WxErrorException, IOException {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/plain; charset=utf-8"), (String)postEntity);
        Request request = new Request.Builder().url(uri).post(body).build();
        Response response = ((OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson(responseContent, wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }
}

