/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.StandardSession;
import me.chanjar.weixin.common.session.TooManyActiveSessionsException;
import me.chanjar.weixin.common.session.WxSession;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.res.StringManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSessionManager
implements WxSessionManager,
InternalSessionManager {
    protected static final StringManager sm = StringManager.getManager("me.chanjar.weixin.common.session");
    private static final String name = "SessionManagerImpl";
    protected final Logger log = LoggerFactory.getLogger(StandardSessionManager.class);
    private final Object maxActiveUpdateLock = new Object();
    private final AtomicBoolean backgroundProcessStarted = new AtomicBoolean(false);
    protected Map<String, InternalSession> sessions = new ConcurrentHashMap<String, InternalSession>();
    protected int maxActiveSessions = -1;
    protected int rejectedSessions = 0;
    protected int maxInactiveInterval = 1800;
    protected long sessionCounter = 0L;
    protected volatile int maxActive = 0;
    protected long processingTime = 0L;
    protected int processExpiresFrequency = 6;
    protected int backgroundProcessorDelay = 10;
    private int count = 0;

    @Override
    public WxSession getSession(String sessionId) {
        return this.getSession(sessionId, true);
    }

    @Override
    public WxSession getSession(String sessionId, boolean create) {
        if (sessionId == null) {
            throw new IllegalStateException(sm.getString("sessionManagerImpl.getSession.ise"));
        }
        InternalSession session = this.findSession(sessionId);
        if (session != null && !session.isValid()) {
            session = null;
        }
        if (session != null) {
            session.access();
            return session.getSession();
        }
        if (!create) {
            return null;
        }
        session = this.createSession(sessionId);
        if (session == null) {
            return null;
        }
        session.access();
        return session.getSession();
    }

    @Override
    public void remove(InternalSession session) {
        this.remove(session, false);
    }

    @Override
    public void remove(InternalSession session, boolean update) {
        if (session.getIdInternal() != null) {
            this.sessions.remove(session.getIdInternal());
        }
    }

    @Override
    public InternalSession findSession(String id) {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    public InternalSession createSession(String sessionId) {
        if (sessionId == null) {
            throw new IllegalStateException(sm.getString("sessionManagerImpl.createSession.ise"));
        }
        if (this.maxActiveSessions >= 0 && this.getActiveSessions() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            throw new TooManyActiveSessionsException(sm.getString("sessionManagerImpl.createSession.tmase"), this.maxActiveSessions);
        }
        InternalSession session = this.createEmptySession();
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String id = sessionId;
        session.setId(id);
        ++this.sessionCounter;
        return session;
    }

    @Override
    public int getActiveSessions() {
        return this.sessions.size();
    }

    @Override
    public InternalSession createEmptySession() {
        return this.getNewSession();
    }

    protected InternalSession getNewSession() {
        return new StandardSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(InternalSession session) {
        if (!this.backgroundProcessStarted.getAndSet(true)) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep((long)StandardSessionManager.this.backgroundProcessorDelay * 1000L);
                                StandardSessionManager.this.backgroundProcess();
                            }
                        }
                        catch (InterruptedException e) {
                            StandardSessionManager.this.log.error("SessionManagerImpl.backgroundProcess error", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
        this.sessions.put(session.getIdInternal(), session);
        int size = this.getActiveSessions();
        if (size > this.maxActive) {
            Object object = this.maxActiveUpdateLock;
            synchronized (object) {
                if (size > this.maxActive) {
                    this.maxActive = size;
                }
            }
        }
    }

    @Override
    public InternalSession[] findSessions() {
        return this.sessions.values().toArray(new InternalSession[0]);
    }

    @Override
    public void backgroundProcess() {
        this.count = (this.count + 1) % this.processExpiresFrequency;
        if (this.count == 0) {
            this.processExpires();
        }
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        InternalSession[] sessions = this.findSessions();
        int expireHere = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start expire sessions {} at {} sessioncount {}", new Object[]{this.getName(), timeNow, sessions.length});
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i] == null || sessions[i].isValid()) continue;
            ++expireHere;
        }
        long timeEnd = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("End expire sessions {} processingTime {} expired sessions: {}", new Object[]{this.getName(), timeEnd - timeNow, expireHere});
        }
        this.processingTime += timeEnd - timeNow;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    @Override
    public void setProcessExpiresFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        this.processExpiresFrequency = processExpiresFrequency;
    }

    @Override
    public void setBackgroundProcessorDelay(int backgroundProcessorDelay) {
        this.backgroundProcessorDelay = backgroundProcessorDelay;
    }

    public String getName() {
        return name;
    }

    @Override
    public void setMaxActiveSessions(int max) {
        this.maxActiveSessions = max;
    }
}

