/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.irr;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="irr.ClockProPlus")
public final class ClockProPlusPolicy
implements Policy.KeyOnlyPolicy {
    private static final boolean debug = false;
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private @Nullable Node listHead;
    private @Nullable Node handHot;
    private @Nullable Node handCold;
    private @Nullable Node handTest;
    private final int maxSize;
    private final int maxNonResSize;
    private int sizeHot;
    private int sizeResCold;
    private int sizeNonResCold;
    private int sizeInTest;
    private int sizeFree;
    private int sizeDemoted;
    private int coldTarget;
    private int minResColdSize;
    private int maxResColdSize;

    public ClockProPlusPolicy(Config config) {
        ClockProPlusSettings settings = new ClockProPlusSettings(config);
        this.maxSize = Math.toIntExact(settings.maximumSize());
        this.maxNonResSize = (int)((double)this.maxSize * settings.nonResidentMultiplier());
        this.minResColdSize = (int)((double)this.maxSize * settings.percentMinCold());
        if (this.minResColdSize < settings.lowerBoundCold()) {
            this.minResColdSize = settings.lowerBoundCold();
        }
        this.maxResColdSize = (int)((double)this.maxSize * settings.percentMaxCold());
        if (this.maxResColdSize > this.maxSize - this.minResColdSize) {
            this.maxResColdSize = this.maxSize - this.minResColdSize;
        }
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.coldTarget = this.minResColdSize;
        this.handTest = null;
        this.handCold = null;
        this.handHot = null;
        this.listHead = null;
        this.sizeFree = this.maxSize;
        Preconditions.checkState((this.minResColdSize <= this.maxResColdSize ? 1 : 0) != 0);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        if (this.policyStats.requestCount() == 0L) {
            return;
        }
        this.validateStatus();
        this.validateClockStructure();
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            node = new Node(key);
            this.data.put(key, (Object)node);
            this.onMiss(node);
        } else if (node.isResident()) {
            this.onHit(node);
        } else {
            this.onMiss(node);
        }
    }

    private void onHit(Node node) {
        this.policyStats.recordHit();
        node.marked = true;
    }

    private void onMiss(Node node) {
        this.policyStats.recordMiss();
        if (this.sizeFree > this.minResColdSize) {
            ClockProPlusPolicy.onHotWarmupMiss(node);
        } else if (this.sizeFree > 0) {
            ClockProPlusPolicy.onColdWarmupMiss(node);
        } else {
            this.onFullMiss(node);
        }
        this.organizeHands();
    }

    private static void onHotWarmupMiss(Node node) {
        node.moveToHead(Status.HOT);
    }

    private static void onColdWarmupMiss(Node node) {
        node.moveToHead(Status.COLD_RES_IN_TEST);
    }

    private void onFullMiss(Node node) {
        if (node.status == Status.COLD_NON_RES) {
            this.onNonResidentFullMiss(node);
        } else if (node.status == Status.OUT_OF_CLOCK) {
            this.onOutOfClockFullMiss(node);
        } else {
            throw new IllegalStateException();
        }
    }

    private void onOutOfClockFullMiss(Node node) {
        this.evict();
        node.moveToHead(Status.COLD_RES_IN_TEST);
    }

    private void onNonResidentFullMiss(Node node) {
        this.evict();
        if (this.canPromote(node)) {
            node.moveToHead(Status.HOT);
        } else {
            node.moveToHead(Status.COLD_RES_IN_TEST);
        }
    }

    private void evict() {
        this.policyStats.recordEviction();
        while (this.sizeFree == 0) {
            this.runHandCold();
        }
    }

    private boolean canPromote(Node candidate) {
        if (!candidate.isInClock() || !candidate.isInTest()) {
            return false;
        }
        if (!candidate.isResident()) {
            this.coldTargetAdjust(true);
        }
        while (this.sizeHot >= this.maxSize - this.coldTarget) {
            if (!candidate.isInTest()) {
                return false;
            }
            if (this.runHandHot(candidate)) continue;
            return false;
        }
        return true;
    }

    private void runHandCold() {
        Objects.requireNonNull(this.handCold);
        Preconditions.checkState((boolean)this.handCold.isResidentCold());
        if (this.handCold.marked) {
            if (this.handCold.isInTest()) {
                if (this.canPromote(this.handCold)) {
                    this.handCold.moveToHead(Status.HOT);
                } else {
                    this.handCold.moveToHead(Status.COLD_RES_IN_TEST);
                }
            } else {
                if (this.handCold.demoted) {
                    this.handCold.demoted = false;
                    this.coldTargetAdjust(false);
                    --this.sizeDemoted;
                }
                this.handCold.moveToHead(Status.COLD_RES_IN_TEST);
            }
        } else {
            if (this.handCold.isInTest()) {
                this.handCold.setStatus(Status.COLD_NON_RES);
                this.handCold = this.handCold.prev;
            } else {
                if (this.handCold.demoted) {
                    this.handCold.demoted = false;
                    --this.sizeDemoted;
                }
                this.handCold.removeFromClock();
            }
            while (this.sizeNonResCold > this.maxNonResSize) {
                this.runHandTest();
            }
        }
        this.nextHandCold();
    }

    private boolean runHandHot(Node trigger) {
        Objects.requireNonNull(this.handHot);
        Preconditions.checkState((boolean)this.handHot.isHot());
        Preconditions.checkState((boolean)trigger.isInTest());
        boolean demoted = false;
        while (this.handHot != trigger) {
            if (this.handHot.isHot()) {
                if (this.handHot.marked) {
                    this.handHot.moveToHead(Status.HOT);
                    continue;
                }
                this.handHot.demoted = true;
                ++this.sizeDemoted;
                this.handHot.moveToHead(Status.COLD_RES);
                demoted = true;
                break;
            }
            if (this.handHot.marked && this.handHot.demoted) {
                this.handHot.demoted = false;
                this.coldTargetAdjust(false);
                --this.sizeDemoted;
            }
            this.handHot = this.handHot.prev;
            ClockProPlusPolicy.terminateTestPeriod(this.handHot.next);
        }
        this.nextHandHot();
        return demoted;
    }

    private void runHandTest() {
        Objects.requireNonNull(this.handTest);
        Preconditions.checkState((boolean)this.handTest.isInTest());
        ClockProPlusPolicy.terminateTestPeriod(this.handTest);
        this.nextHandTest();
    }

    private static void terminateTestPeriod(Node node) {
        if (!node.isInTest()) {
            return;
        }
        if (node.isResidentCold()) {
            node.setStatus(Status.COLD_RES);
        } else {
            Preconditions.checkState((!node.demoted ? 1 : 0) != 0);
            node.removeFromClock();
        }
    }

    private void nextHandCold() {
        if (this.sizeResCold > 0) {
            if (this.handCold == null) {
                this.handCold = Objects.requireNonNull(this.listHead).prev;
            }
            while (!this.handCold.isResidentCold()) {
                this.handCold = Objects.requireNonNull(this.handCold).prev;
            }
        } else {
            this.handCold = null;
        }
    }

    private void nextHandHot() {
        if (this.sizeHot > 0) {
            if (this.handHot == null) {
                this.handHot = Objects.requireNonNull(this.listHead).prev;
            }
            while (this.handHot.isCold()) {
                this.handHot = this.handHot.prev;
                ClockProPlusPolicy.terminateTestPeriod(this.handHot.next);
            }
            this.nextHandTest();
        } else {
            this.handHot = null;
        }
    }

    private void nextHandTest() {
        if (this.sizeInTest > 0) {
            if (this.handTest == null) {
                Node node = this.handTest = this.handHot == null ? Objects.requireNonNull(this.listHead).prev : this.handHot;
            }
            while (!this.handTest.isInTest()) {
                this.handTest = this.handTest.prev;
            }
        } else {
            this.handTest = null;
        }
    }

    private void organizeHands() {
        this.nextHandCold();
        this.nextHandHot();
        this.nextHandTest();
    }

    private void coldTargetAdjust(boolean increase) {
        int delta = 0;
        if (increase) {
            if (this.sizeNonResCold != 0) {
                delta = this.sizeDemoted / this.sizeNonResCold;
            }
        } else if (this.sizeDemoted != 0) {
            delta = this.sizeNonResCold / this.sizeDemoted;
        }
        if (delta < 1) {
            delta = 1;
        }
        if (!increase) {
            delta *= -1;
        }
        this.coldTargetAdjust(delta);
    }

    private void coldTargetAdjust(int n) {
        this.coldTarget += n;
        if (this.coldTarget < this.minResColdSize) {
            this.coldTarget = this.minResColdSize;
        } else if (this.coldTarget > this.maxResColdSize) {
            this.coldTarget = this.maxResColdSize;
        }
    }

    private void validateClockStructure() {
        Node n;
        Preconditions.checkState((this.listHead != null ? 1 : 0) != 0);
        if (this.handHot == null) {
            Preconditions.checkState((this.sizeHot == 0 ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((boolean)this.handHot.isHot());
            n = this.listHead.prev;
            while (n != this.handHot) {
                Preconditions.checkState((!n.isInTest() ? 1 : 0) != 0);
                Preconditions.checkState((n != this.handTest ? 1 : 0) != 0);
                n = n.prev;
            }
        }
        if (this.handCold == null) {
            Preconditions.checkState((this.sizeResCold == 0 ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((boolean)this.handCold.isResidentCold());
            n = this.listHead.prev;
            while (n != this.handCold) {
                Preconditions.checkState((!n.isResidentCold() ? 1 : 0) != 0);
                n = n.prev;
            }
        }
        if (this.handTest == null) {
            Preconditions.checkState((this.sizeInTest == 0 ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((boolean)this.handTest.isInTest());
            n = this.listHead.prev;
            while (n != this.handTest) {
                Preconditions.checkState((boolean)n.isResident());
                Preconditions.checkState((!n.isInTest() ? 1 : 0) != 0);
                n = n.prev;
            }
        }
    }

    private void validateStatus() {
        Preconditions.checkState((this.listHead != null ? 1 : 0) != 0);
        int hotSize = 0;
        int inTestSize = 0;
        int resColdSize = 0;
        int nonResColdSize = 0;
        int recentlyDemotedSize = 0;
        Node node = this.listHead;
        while (node != null) {
            Preconditions.checkState((boolean)node.isInClock());
            if (node.isHot()) {
                ++hotSize;
            }
            if (node.isInTest()) {
                ++inTestSize;
            }
            if (node.isResidentCold()) {
                ++resColdSize;
            }
            if (!node.isResident()) {
                ++nonResColdSize;
            }
            if (node.demoted) {
                ++recentlyDemotedSize;
            }
            if ((node = node.next) != this.listHead) continue;
        }
        Preconditions.checkState((hotSize == this.sizeHot ? 1 : 0) != 0);
        Preconditions.checkState((inTestSize == this.sizeInTest ? 1 : 0) != 0);
        Preconditions.checkState((resColdSize == this.sizeResCold ? 1 : 0) != 0);
        Preconditions.checkState((resColdSize <= this.maxResColdSize ? 1 : 0) != 0);
        Preconditions.checkState((nonResColdSize <= this.maxNonResSize ? 1 : 0) != 0);
        Preconditions.checkState((nonResColdSize == this.sizeNonResCold ? 1 : 0) != 0);
        Preconditions.checkState((recentlyDemotedSize == this.sizeDemoted ? 1 : 0) != 0);
        Preconditions.checkState((resColdSize + this.sizeFree >= this.minResColdSize ? 1 : 0) != 0);
        Preconditions.checkState((hotSize + resColdSize == this.maxSize - this.sizeFree ? 1 : 0) != 0);
    }

    private void printClock() {
        System.out.println("** CLOCK-Pro list HEAD (small recency) **");
        System.out.println(this.listHead);
        Objects.requireNonNull(this.listHead);
        Node n = this.listHead.next;
        while (n != this.listHead) {
            System.out.println(n);
            n = n.next;
        }
        System.out.println("** CLOCK-Pro list TAIL (large recency) **");
    }

    static final class ClockProPlusSettings
    extends BasicSettings {
        public ClockProPlusSettings(Config config) {
            super(config);
        }

        public int lowerBoundCold() {
            return this.config().getInt("clockproplus.lower-bound-resident-cold");
        }

        public double percentMinCold() {
            return this.config().getDouble("clockproplus.percent-min-resident-cold");
        }

        public double percentMaxCold() {
            return this.config().getDouble("clockproplus.percent-max-resident-cold");
        }

        public double nonResidentMultiplier() {
            return this.config().getDouble("clockproplus.non-resident-multiplier");
        }
    }

    final class Node {
        final long key;
        Status status;
        Node prev;
        Node next;
        boolean marked;
        boolean demoted;

        public Node(long key) {
            this.key = key;
            this.prev = this.next = this;
            this.status = Status.OUT_OF_CLOCK;
        }

        public void moveToHead(Status status) {
            if (this.isInClock()) {
                this.removeFromClock();
            }
            if (ClockProPlusPolicy.this.listHead == null) {
                this.next = this.prev = this;
            } else {
                this.next = ClockProPlusPolicy.this.listHead;
                this.prev = ClockProPlusPolicy.this.listHead.prev;
                ClockProPlusPolicy.this.listHead.prev.next = this;
                ClockProPlusPolicy.this.listHead.prev = this;
            }
            this.setStatus(status);
            ClockProPlusPolicy.this.listHead = this;
        }

        public void removeFromClock() {
            if (this == ClockProPlusPolicy.this.listHead) {
                ClockProPlusPolicy.this.listHead = ClockProPlusPolicy.this.listHead.next;
            }
            if (this == ClockProPlusPolicy.this.handCold) {
                ClockProPlusPolicy.this.handCold = ClockProPlusPolicy.this.handCold.prev;
            }
            if (this == ClockProPlusPolicy.this.handHot) {
                ClockProPlusPolicy.this.handHot = ClockProPlusPolicy.this.handHot.prev;
            }
            if (this == ClockProPlusPolicy.this.handTest) {
                ClockProPlusPolicy.this.handTest = ClockProPlusPolicy.this.handTest.prev;
            }
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = this.next = this;
            this.setStatus(Status.OUT_OF_CLOCK);
            this.marked = false;
        }

        public void setStatus(Status status) {
            if (this.isResident()) {
                ++ClockProPlusPolicy.this.sizeFree;
            }
            if (this.isInTest()) {
                --ClockProPlusPolicy.this.sizeInTest;
            }
            if (this.isResidentCold()) {
                --ClockProPlusPolicy.this.sizeResCold;
            }
            if (this.status == Status.COLD_NON_RES) {
                --ClockProPlusPolicy.this.sizeNonResCold;
            }
            if (this.status == Status.HOT) {
                --ClockProPlusPolicy.this.sizeHot;
            }
            this.status = status;
            if (this.isResident()) {
                --ClockProPlusPolicy.this.sizeFree;
            }
            if (this.isInTest()) {
                ++ClockProPlusPolicy.this.sizeInTest;
            }
            if (this.isResidentCold()) {
                ++ClockProPlusPolicy.this.sizeResCold;
            }
            if (this.status == Status.COLD_NON_RES) {
                ++ClockProPlusPolicy.this.sizeNonResCold;
            }
            if (this.status == Status.HOT) {
                ++ClockProPlusPolicy.this.sizeHot;
            }
        }

        boolean isInTest() {
            return this.status == Status.COLD_RES_IN_TEST || this.status == Status.COLD_NON_RES;
        }

        boolean isResident() {
            return this.isResidentCold() || this.status == Status.HOT;
        }

        boolean isResidentCold() {
            return this.status == Status.COLD_RES || this.status == Status.COLD_RES_IN_TEST;
        }

        boolean isCold() {
            return this.isResidentCold() || this.status == Status.COLD_NON_RES;
        }

        boolean isHot() {
            return this.status == Status.HOT;
        }

        boolean isInClock() {
            return this.status != Status.OUT_OF_CLOCK;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(MoreObjects.toStringHelper((Object)this).add("key", this.key).add("marked", this.marked).add("demoted", this.demoted).add("type", (Object)this.status).toString());
            if (this == ClockProPlusPolicy.this.handHot) {
                sb.append(" <--[ HAND_HOT ]");
            }
            if (this == ClockProPlusPolicy.this.handCold) {
                sb.append(" <--[ HAND_COLD ]");
            }
            if (this == ClockProPlusPolicy.this.handTest) {
                sb.append(" <--[ HAND_TEST ]");
            }
            return sb.toString();
        }
    }

    static enum Status {
        HOT,
        COLD_RES,
        COLD_RES_IN_TEST,
        COLD_NON_RES,
        OUT_OF_CLOCK;

    }
}

