/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.ClimberResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.IncrementalResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.IndicatorResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.PeriodicResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin64.CountMin64TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.admission.perfect.PerfectFrequency;
import com.github.benmanes.caffeine.cache.simulator.admission.table.RandomRemovalFrequencyTable;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheAdapter;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.typesafe.config.Config;
import java.util.Locale;
import java.util.Random;

public final class TinyLfu
implements Admittor.KeyOnlyAdmittor {
    private final PolicyStats policyStats;
    private final Frequency sketch;
    private final Random random;
    private final double probability;
    private final int threshold;

    public TinyLfu(Config config, PolicyStats policyStats) {
        BasicSettings settings = new BasicSettings(config);
        this.random = new Random(settings.randomSeed());
        this.sketch = TinyLfu.makeSketch(settings);
        this.policyStats = policyStats;
        if (settings.tinyLfu().jitter().enabled()) {
            this.threshold = settings.tinyLfu().jitter().threshold();
            this.probability = settings.tinyLfu().jitter().probability();
        } else {
            this.threshold = Integer.MAX_VALUE;
            this.probability = 1.0;
        }
    }

    public int frequency(long key) {
        return this.sketch.frequency(key);
    }

    @Override
    public void record(long key) {
        this.sketch.increment(key);
    }

    @Override
    public boolean admit(long candidateKey, long victimKey) {
        this.sketch.reportMiss();
        int victimFreq = this.sketch.frequency(victimKey);
        int candidateFreq = this.sketch.frequency(candidateKey);
        if (candidateFreq > victimFreq || candidateFreq >= this.threshold && (double)this.random.nextFloat() < this.probability) {
            this.policyStats.recordAdmission();
            return true;
        }
        this.policyStats.recordRejection();
        return false;
    }

    private static Frequency makeSketch(BasicSettings settings) {
        String type = settings.tinyLfu().sketch();
        return switch (type.toLowerCase(Locale.US)) {
            case "count-min-4" -> {
                String reset = settings.tinyLfu().countMin4().reset();
                switch (reset.toLowerCase(Locale.US)) {
                    case "climber": {
                        yield new ClimberResetCountMin4(settings.config());
                    }
                    case "periodic": {
                        yield new PeriodicResetCountMin4(settings.config());
                    }
                    case "indicator": {
                        yield new IndicatorResetCountMin4(settings.config());
                    }
                    case "incremental": {
                        yield new IncrementalResetCountMin4(settings.config());
                    }
                }
                throw new IllegalStateException("Unknown reset type: " + reset);
            }
            case "tiny-table" -> new TinyCacheAdapter(settings.config());
            case "count-min-64" -> new CountMin64TinyLfu(settings.config());
            case "perfect-table" -> new PerfectFrequency(settings.config());
            case "random-table" -> new RandomRemovalFrequencyTable(settings.config());
            default -> throw new IllegalStateException("Unknown sketch type: " + type);
        };
    }
}

