/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.two_queue;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.IntConsumer;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="two-queue.S3Fifo", characteristics={Policy.Characteristic.WEIGHTED})
public final class S3FifoPolicy
implements Policy {
    final Long2ObjectMap<Node> dataGhost = new Long2ObjectOpenHashMap();
    final Long2ObjectMap<Node> dataSmall = new Long2ObjectOpenHashMap();
    final Long2ObjectMap<Node> dataMain = new Long2ObjectOpenHashMap();
    final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);
    final Node sentinelGhost = new Node();
    final Node sentinelSmall = new Node();
    final Node sentinelMain = new Node();
    final int moveToMainThreshold;
    final int maxFrequency;
    final long maximumSize;
    final long maxGhost;
    final long maxSmall;
    final long maxMain;
    long sizeGhost;
    long sizeSmall;
    long sizeMain;

    public S3FifoPolicy(Config config) {
        S3FifoSettings settings = new S3FifoSettings(config);
        this.maximumSize = settings.maximumSize();
        this.maxFrequency = settings.maximumFrequency();
        this.moveToMainThreshold = settings.moveToMainThreshold();
        this.maxSmall = (long)((double)this.maximumSize * settings.percentSmall());
        this.maxGhost = (long)((double)this.maximumSize * settings.percentGhost());
        this.maxMain = this.maximumSize - this.maxSmall;
    }

    @Override
    public void record(AccessEvent event) {
        Node node = (Node)this.dataSmall.get(event.key());
        if (node != null) {
            this.onHit(event, node, change -> this.sizeSmall += (long)change);
        } else {
            node = (Node)this.dataMain.get(event.key());
            if (node != null) {
                this.onHit(event, node, change -> this.sizeMain += (long)change);
            } else if ((long)event.weight() > this.maximumSize) {
                this.policyStats.recordWeightedMiss(event.weight());
            } else {
                this.policyStats.recordWeightedMiss(event.weight());
                node = this.insert(event);
                node.frequency = 0;
            }
        }
        this.policyStats.recordOperation();
    }

    private void onHit(AccessEvent event, Node node, IntConsumer sizeAdjuster) {
        node.frequency = Math.min(node.frequency + 1, this.maxFrequency);
        sizeAdjuster.accept(event.weight() - node.weight);
        node.weight = event.weight();
        this.policyStats.recordWeightedHit(event.weight());
        while (this.sizeSmall + this.sizeMain > this.maximumSize) {
            this.evict();
        }
    }

    private Node insert(AccessEvent event) {
        while (this.sizeSmall + this.sizeMain + (long)event.weight() > this.maximumSize) {
            this.evict();
        }
        Node ghost = (Node)this.dataGhost.remove(event.key());
        if (ghost != null) {
            ghost.remove();
            this.sizeGhost -= (long)ghost.weight;
            return this.insertMain(event.key(), event.weight());
        }
        return this.insertSmall(event.key(), event.weight());
    }

    @CanIgnoreReturnValue
    private Node insertMain(long key, int weight) {
        Node node = new Node(key, weight);
        node.appendAtHead(this.sentinelMain);
        this.dataMain.put(key, (Object)node);
        this.sizeMain += (long)node.weight;
        return node;
    }

    private Node insertSmall(long key, int weight) {
        Node node = new Node(key, weight);
        node.appendAtHead(this.sentinelSmall);
        this.dataSmall.put(key, (Object)node);
        this.sizeSmall += (long)node.weight;
        return node;
    }

    private void insertGhost(long key, int weight) {
        if ((long)weight > this.maxGhost) {
            return;
        }
        while (this.sizeGhost + (long)weight > this.maxGhost) {
            this.evictFromGhost();
        }
        Node node = new Node(key, weight);
        node.appendAtHead(this.sentinelGhost);
        this.dataGhost.put(key, (Object)node);
        this.sizeGhost += (long)node.weight;
    }

    private void evict() {
        if (this.sizeSmall >= this.maxSmall || this.dataMain.isEmpty()) {
            this.evictFromSmall();
        } else {
            this.evictFromMain();
        }
    }

    private void evictFromSmall() {
        boolean evicted = false;
        while (!evicted && !this.dataSmall.isEmpty()) {
            Node victim = Objects.requireNonNull(this.sentinelSmall.prev);
            this.policyStats.recordOperation();
            if (victim.frequency > this.moveToMainThreshold) {
                this.insertMain(victim.key, victim.weight);
                if (this.sizeMain > this.maxMain) {
                    this.evictFromMain();
                }
            } else {
                this.insertGhost(victim.key, victim.weight);
                evicted = true;
            }
            this.policyStats.recordEviction();
            this.dataSmall.remove(victim.key);
            this.sizeSmall -= (long)victim.weight;
            victim.remove();
        }
    }

    private void evictFromMain() {
        boolean evicted = false;
        while (!evicted && !this.dataMain.isEmpty()) {
            Node victim = Objects.requireNonNull(this.sentinelMain.prev);
            this.policyStats.recordOperation();
            if (victim.frequency > 0) {
                victim.moveToHead(this.sentinelMain);
                --victim.frequency;
                continue;
            }
            this.policyStats.recordEviction();
            this.dataMain.remove(victim.key);
            this.sizeMain -= (long)victim.weight;
            victim.remove();
            evicted = true;
        }
    }

    private void evictFromGhost() {
        if (!this.dataGhost.isEmpty()) {
            Node victim = Objects.requireNonNull(this.sentinelGhost.prev);
            this.dataGhost.remove(victim.key);
            this.sizeGhost -= (long)victim.weight;
            victim.remove();
        }
    }

    @Override
    public void finished() {
        long actualGhost = this.dataGhost.values().stream().mapToLong(node -> node.weight).sum();
        Preconditions.checkState((actualGhost == this.sizeGhost ? 1 : 0) != 0, (String)"Ghost: %s != %s", (long)actualGhost, (long)this.sizeGhost);
        Preconditions.checkState((this.sizeGhost <= this.maxGhost ? 1 : 0) != 0, (String)"Ghost: %s > %s", (long)this.sizeGhost, (long)this.maxGhost);
        S3FifoPolicy.checkLinks("Ghost", this.dataGhost, this.sentinelGhost);
        long actualSmall = this.dataSmall.values().stream().mapToLong(node -> node.weight).sum();
        Preconditions.checkState((actualSmall == this.sizeSmall ? 1 : 0) != 0, (String)"Small: %s != %s", (long)actualSmall, (long)this.sizeSmall);
        S3FifoPolicy.checkLinks("Small", this.dataSmall, this.sentinelSmall);
        long actualMain = this.dataMain.values().stream().mapToLong(node -> node.weight).sum();
        Preconditions.checkState((actualMain == this.sizeMain ? 1 : 0) != 0, (String)"Main: %s != %s", (long)actualMain, (long)this.sizeMain);
        S3FifoPolicy.checkLinks("Main", this.dataMain, this.sentinelMain);
        long actualSize = this.sizeSmall + this.sizeMain;
        Preconditions.checkState((actualSize <= this.maximumSize ? 1 : 0) != 0, (String)"Total: %s > %s", (long)actualSize, (long)this.maximumSize);
    }

    private static void checkLinks(String label, Long2ObjectMap<Node> data, Node sentinel) {
        LinkedHashSet<Node> forwards = new LinkedHashSet<Node>();
        Node node = sentinel.next;
        while (node != sentinel) {
            Objects.requireNonNull(node);
            Preconditions.checkState((node == data.get(node.key) ? 1 : 0) != 0, (String)"%s: %s != %s", (Object)label, (Object)node, (Object)data.get(node.key));
            Preconditions.checkState((boolean)forwards.add(node), (String)"%s: loop detected %s", (Object)label, forwards);
            node = node.next;
        }
        Preconditions.checkState((forwards.size() == data.size() ? 1 : 0) != 0, (String)"%s (forwards): %s != %s", (Object)label, (Object)forwards.size(), (Object)data.size());
        LinkedHashSet<Node> backwards = new LinkedHashSet<Node>();
        Node node2 = sentinel.prev;
        while (node2 != sentinel) {
            Objects.requireNonNull(node2);
            Preconditions.checkState((node2 == data.get(node2.key) ? 1 : 0) != 0, (String)"%s: %s != %s", (Object)label, (Object)node2, (Object)data.get(node2.key));
            Preconditions.checkState((boolean)backwards.add(node2), (String)"%s: loop detected %s", (Object)label, backwards);
            node2 = node2.prev;
        }
        Preconditions.checkState((backwards.size() == data.size() ? 1 : 0) != 0, (String)"%s (backwards): %s != %s", (Object)label, (Object)backwards.size(), (Object)data.size());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class Node {
        final long key;
        @Nullable Node prev;
        @Nullable Node next;
        int weight;
        int frequency;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key, int weight) {
            this.key = key;
            this.weight = weight;
        }

        public void appendAtHead(Node sentinel) {
            Preconditions.checkState((this.prev == null ? 1 : 0) != 0);
            Preconditions.checkState((this.next == null ? 1 : 0) != 0);
            Node head = Objects.requireNonNull(sentinel.next);
            sentinel.next = this;
            head.prev = this;
            this.next = head;
            this.prev = sentinel;
        }

        public void moveToHead(Node sentinel) {
            Preconditions.checkState((this.prev != null ? 1 : 0) != 0);
            Preconditions.checkState((this.next != null ? 1 : 0) != 0);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = Objects.requireNonNull(sentinel.next);
            sentinel.next = this;
            this.next.prev = this;
            this.prev = sentinel;
        }

        public void remove() {
            Preconditions.checkState((this.prev != null ? 1 : 0) != 0);
            Preconditions.checkState((this.next != null ? 1 : 0) != 0);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("weight", this.weight).add("freq", this.frequency).toString();
        }
    }

    static final class S3FifoSettings
    extends BasicSettings {
        public S3FifoSettings(Config config) {
            super(config);
        }

        public double percentSmall() {
            return this.config().getDouble("s3fifo.percent-small");
        }

        public double percentGhost() {
            return this.config().getDouble("s3fifo.percent-ghost");
        }

        public int moveToMainThreshold() {
            return this.config().getInt("s3fifo.move-to-main-threshold");
        }

        public int maximumFrequency() {
            return this.config().getInt("s3fifo.maximum-frequency");
        }
    }
}

