/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.CaseFormat;
import com.typesafe.config.Config;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;

@Policy.PolicySpec(name="product.ExpiringMap")
public final class ExpiringMapPolicy
implements Policy.KeyOnlyPolicy {
    private final ExpiringMap<Long, Boolean> cache;
    private final PolicyStats policyStats;

    public ExpiringMapPolicy(ExpiringMapSettings settings, Eviction policy) {
        this.policyStats = new PolicyStats(this.name() + " (%s)", new Object[]{policy});
        this.cache = ExpiringMap.builder().maxSize(Math.toIntExact(settings.maximumSize())).expirationPolicy(policy.type).build();
    }

    public static Set<Policy> policies(Config config) {
        ExpiringMapSettings settings = new ExpiringMapSettings(config);
        return settings.policy().stream().map(policy -> new ExpiringMapPolicy(settings, (Eviction)((Object)policy))).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(long key) {
        Boolean value = (Boolean)this.cache.get((Object)key);
        if (value == null) {
            if (this.cache.size() == this.cache.getMaxSize()) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, (Object)Boolean.TRUE);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static enum Eviction {
        FIFO(ExpirationPolicy.CREATED),
        LRU(ExpirationPolicy.ACCESSED);

        final ExpirationPolicy type;

        private Eviction(ExpirationPolicy type) {
            this.type = type;
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    static final class ExpiringMapSettings
    extends BasicSettings {
        public ExpiringMapSettings(Config config) {
            super(config);
        }

        public Set<Eviction> policy() {
            EnumSet<Eviction> policies = EnumSet.noneOf(Eviction.class);
            for (String policy : this.config().getStringList("expiring-map.policy")) {
                if (policy.equalsIgnoreCase("fifo")) {
                    policies.add(Eviction.FIFO);
                    continue;
                }
                if (policy.equalsIgnoreCase("lru")) {
                    policies.add(Eviction.LRU);
                    continue;
                }
                throw new IllegalArgumentException("Unknown policy: " + policy);
            }
            return policies;
        }
    }
}

