/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.Set;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;

@Policy.PolicySpec(name="product.ElasticSearch", characteristics={Policy.Characteristic.WEIGHTED})
public final class ElasticSearchPolicy
implements Policy {
    private final Cache<Long, AccessEvent> cache;
    private final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);

    public ElasticSearchPolicy(Config config, Set<Policy.Characteristic> characteristics) {
        BasicSettings settings = new BasicSettings(config);
        CacheBuilder builder = CacheBuilder.builder().removalListener(notification -> this.policyStats.recordEviction()).setMaximumWeight(settings.maximumSize());
        if (characteristics.contains((Object)Policy.Characteristic.WEIGHTED)) {
            builder.weigher((key, value) -> value.weight());
        }
        this.cache = builder.build();
    }

    @Override
    public void record(AccessEvent event) {
        AccessEvent value = (AccessEvent)this.cache.get((Object)event.key());
        if (value == null) {
            this.cache.put((Object)event.key(), (Object)event);
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            if (event.weight() != value.weight()) {
                this.cache.put((Object)event.key(), (Object)event);
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Cache.CacheStats stats = this.cache.stats();
        Preconditions.checkState((this.policyStats.hitCount() == stats.getHits() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == stats.getMisses() ? 1 : 0) != 0);
    }
}

