/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.perfect;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;

public final class PerfectFrequency
implements Frequency {
    private final Long2IntMap counts;
    private final int sampleSize;
    private int size;

    public PerfectFrequency(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.sampleSize = Ints.checkedCast((long)(10L * settings.maximumSize()));
        this.counts = new Long2IntOpenHashMap();
    }

    @Override
    public int frequency(long e) {
        return this.counts.get(e);
    }

    @Override
    public void increment(long e) {
        this.counts.put(e, this.counts.get(e) + 1);
        ++this.size;
        if (this.size == this.sampleSize) {
            this.reset();
        }
    }

    private void reset() {
        for (Long2IntMap.Entry entry : this.counts.long2IntEntrySet()) {
            entry.setValue(entry.getIntValue() / 2);
        }
        this.size /= 2;
    }
}

