/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.gradient;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.AbstractClimber;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import java.util.List;

public final class AmsGrad
extends AbstractClimber {
    private final int stepSize;
    private final double beta1;
    private final double beta2;
    private final double epsilon;
    private double moment;
    private double velocity;
    private double maxVelocity;

    public AmsGrad(Config config) {
        AmsGradSettings settings = new AmsGradSettings(config);
        int maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.sampleSize = (int)(settings.percentSample() * (double)maximumSize);
        this.stepSize = (int)(settings.percentPivot() * (double)maximumSize);
        this.epsilon = settings.epsilon();
        this.beta1 = settings.beta1();
        this.beta2 = settings.beta2();
    }

    @Override
    protected double adjust(double hitRate) {
        double currentMissRate = 1.0 - hitRate;
        double previousMissRate = 1.0 - this.previousHitRate;
        double gradient = currentMissRate - previousMissRate;
        this.moment = this.beta1 * this.moment + (1.0 - this.beta1) * gradient;
        this.velocity = this.beta2 * this.velocity + (1.0 - this.beta2) * (gradient * gradient);
        this.maxVelocity = Math.max(this.velocity, this.maxVelocity);
        return (double)this.stepSize * this.moment / (Math.sqrt(this.maxVelocity) + this.epsilon);
    }

    static final class AmsGradSettings
    extends BasicSettings {
        static final String BASE_PATH = "hill-climber-window-tiny-lfu.amsgrad.";

        public AmsGradSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("hill-climber-window-tiny-lfu.percent-main");
        }

        public double percentPivot() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.amsgrad.percent-pivot");
        }

        public double percentSample() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.amsgrad.percent-sample");
        }

        public double beta1() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.amsgrad.beta1");
        }

        public double beta2() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.amsgrad.beta2");
        }

        public double epsilon() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.amsgrad.epsilon");
        }
    }
}

