/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.adaptive;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Set;

public final class CartPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final int maximumSize;
    private final Node headT1;
    private final Node headT2;
    private final Node headB1;
    private final Node headB2;
    private int sizeT1;
    private int sizeT2;
    private int sizeB1;
    private int sizeB2;
    private int sizeS;
    private int sizeL;
    private int p;
    private int q;

    public CartPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.policyStats = new PolicyStats("adaptive.Cart");
        this.data = new Long2ObjectOpenHashMap();
        this.headT1 = new Node();
        this.headT2 = new Node();
        this.headB1 = new Node();
        this.headB2 = new Node();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new CartPolicy(config));
    }

    @Override
    public void record(long key) {
        Node node = (Node)this.data.get(key);
        if (CartPolicy.isHit(node)) {
            this.policyStats.recordHit();
            this.onHit(node);
        } else {
            this.policyStats.recordMiss();
            this.onMiss(key, node);
        }
    }

    private static boolean isHit(Node node) {
        return node != null && (node.type == QueueType.T1 || node.type == QueueType.T2);
    }

    private void onHit(Node node) {
        node.marked = true;
        this.policyStats.recordOperation();
    }

    private void onMiss(long key, Node node) {
        this.policyStats.recordOperation();
        if (this.sizeT1 + this.sizeT2 == this.maximumSize) {
            this.demote();
            if (!CartPolicy.isGhost(node) && this.sizeB1 + this.sizeB2 == this.maximumSize + 1) {
                if (this.sizeB1 > Math.max(0, this.q) || this.sizeB2 == 0) {
                    Node victim = this.headB1.next;
                    this.data.remove(victim.key);
                    victim.remove();
                    --this.sizeB1;
                } else {
                    Node victim = this.headB2.next;
                    this.data.remove(victim.key);
                    victim.remove();
                    --this.sizeB2;
                }
            }
        }
        if (!CartPolicy.isGhost(node)) {
            Preconditions.checkState((node == null ? 1 : 0) != 0);
            node = new Node(key);
            node.appendToTail(this.headT1);
            node.type = QueueType.T1;
            this.data.put(key, (Object)node);
            ++this.sizeT1;
            node.filter = FilterType.ShortTerm;
            ++this.sizeS;
        } else if (node.type == QueueType.B1) {
            this.p = Math.min(this.p + Math.max(1, this.sizeS / this.sizeB1), this.maximumSize);
            node.remove();
            --this.sizeB1;
            node.appendToTail(this.headT1);
            node.type = QueueType.T1;
            ++this.sizeT1;
            node.filter = FilterType.LongTerm;
            node.marked = false;
            ++this.sizeL;
        } else if (node.type == QueueType.B2) {
            this.p = Math.max(this.p - Math.max(1, this.sizeL / this.sizeB2), 0);
            node.remove();
            --this.sizeB2;
            node.appendToTail(this.headT1);
            node.type = QueueType.T1;
            ++this.sizeT1;
            node.filter = FilterType.LongTerm;
            node.marked = false;
            ++this.sizeL;
            if (this.sizeT2 + this.sizeB2 + this.sizeT1 - this.sizeS >= this.maximumSize) {
                this.q = Math.min(this.q + 1, 2 * this.maximumSize - this.sizeT1);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private static boolean isGhost(Node node) {
        return node != null && (node.type == QueueType.B1 || node.type == QueueType.B2);
    }

    private void demote() {
        Node demoted;
        this.policyStats.recordEviction();
        while (this.headT2.next.marked) {
            this.policyStats.recordOperation();
            demoted = this.headT2.next;
            demoted.marked = false;
            demoted.remove();
            --this.sizeT2;
            demoted.appendToTail(this.headT1);
            demoted.type = QueueType.T1;
            ++this.sizeT1;
            if (this.sizeT2 + this.sizeB2 + this.sizeT1 - this.sizeS < this.maximumSize) continue;
            this.q = Math.min(this.q + 1, 2 * this.maximumSize - this.sizeT1);
        }
        while (this.headT1.next.filter == FilterType.LongTerm || this.headT1.next.marked) {
            this.policyStats.recordOperation();
            Node node = this.headT1.next;
            if (node.marked) {
                node.moveToTail(this.headT1);
                node.marked = false;
                if (this.sizeT1 < Math.max(this.p + 1, this.sizeB1) || node.filter != FilterType.ShortTerm) continue;
                node.filter = FilterType.LongTerm;
                --this.sizeS;
                ++this.sizeL;
                continue;
            }
            node.remove();
            node.type = QueueType.T2;
            node.appendToTail(this.headT2);
            --this.sizeT1;
            ++this.sizeT2;
            this.q = Math.max(this.q - 1, this.maximumSize - this.sizeT1);
        }
        if (this.sizeT1 >= Math.max(1, this.p)) {
            demoted = this.headT1.next;
            demoted.remove();
            demoted.type = QueueType.B1;
            demoted.appendToTail(this.headB1);
            --this.sizeT1;
            ++this.sizeB1;
            --this.sizeS;
        } else {
            demoted = this.headT2.next;
            demoted.remove();
            demoted.type = QueueType.B2;
            demoted.appendToTail(this.headB2);
            --this.sizeT2;
            ++this.sizeB2;
            --this.sizeL;
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Preconditions.checkState(((long)this.sizeT1 == this.data.values().stream().filter(node -> node.type == QueueType.T1).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeT2 == this.data.values().stream().filter(node -> node.type == QueueType.T2).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeB1 == this.data.values().stream().filter(node -> node.type == QueueType.B1).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeB2 == this.data.values().stream().filter(node -> node.type == QueueType.B2).count() ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeT1 + this.sizeT2 <= this.maximumSize ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeB1 + this.sizeB2 <= this.maximumSize ? 1 : 0) != 0);
    }

    static final class Node {
        final long key;
        Node prev;
        Node next;
        QueueType type;
        FilterType filter;
        boolean marked;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key) {
            this.key = key;
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void moveToTail(Node head) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = head;
            this.prev = head.prev;
            head.prev = this;
            this.prev.next = this;
        }

        public void remove() {
            Preconditions.checkState((this.key != Long.MIN_VALUE ? 1 : 0) != 0);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
            this.type = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.type).toString();
        }
    }

    private static enum FilterType {
        ShortTerm,
        LongTerm;

    }

    private static enum QueueType {
        T1,
        B1,
        T2,
        B2;

    }
}

