/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.Objects;

public final class PolicyStats {
    private final Stopwatch stopwatch;
    private String name;
    private long hitCount;
    private long missCount;
    private long hitsWeight;
    private long missesWeight;
    private double hitPenalty;
    private double missPenalty;
    private long evictionCount;
    private long admittedCount;
    private long rejectedCount;
    private long operationCount;

    @FormatMethod
    public PolicyStats(@FormatString String format, Object ... args) {
        this(String.format(format, args));
    }

    public PolicyStats(String name) {
        this.name = Objects.requireNonNull(name);
        this.stopwatch = Stopwatch.createUnstarted();
    }

    public Stopwatch stopwatch() {
        return this.stopwatch;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public void recordOperation() {
        ++this.operationCount;
    }

    public long operationCount() {
        return this.operationCount;
    }

    public void addOperations(long operations) {
        this.operationCount += operations;
    }

    public void recordHit() {
        ++this.hitCount;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public void addHits(long hits) {
        this.hitCount += hits;
    }

    public void recordWeightedHit(int weight) {
        this.hitsWeight += (long)weight;
        this.recordHit();
    }

    public long hitsWeight() {
        return this.hitsWeight;
    }

    public void recordHitPenalty(double penalty) {
        this.hitPenalty += penalty;
    }

    public double hitPenalty() {
        return this.hitPenalty;
    }

    public void recordMiss() {
        ++this.missCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public void addMisses(long misses) {
        this.missCount += misses;
    }

    public void recordWeightedMiss(int weight) {
        this.missesWeight += (long)weight;
        this.recordMiss();
    }

    public long missesWeight() {
        return this.missesWeight;
    }

    public void recordMissPenalty(double penalty) {
        this.missPenalty += penalty;
    }

    public double missPenalty() {
        return this.missPenalty;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public void recordEviction() {
        ++this.evictionCount;
    }

    public void addEvictions(long evictions) {
        this.evictionCount += evictions;
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public long requestsWeight() {
        return this.hitsWeight + this.missesWeight;
    }

    public long admissionCount() {
        return this.admittedCount;
    }

    public void recordAdmission() {
        ++this.admittedCount;
    }

    public long rejectionCount() {
        return this.rejectedCount;
    }

    public void recordRejection() {
        ++this.rejectedCount;
    }

    public double totalPenalty() {
        return this.hitPenalty + this.missPenalty;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public double weightedHitRate() {
        long requestsWeight = this.requestsWeight();
        return requestsWeight == 0L ? 1.0 : (double)this.hitsWeight / (double)requestsWeight;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public double weightedMissRate() {
        long requestsWeight = this.requestsWeight();
        return requestsWeight == 0L ? 1.0 : (double)this.missesWeight / (double)requestsWeight;
    }

    public double admissionRate() {
        long candidateCount = this.admittedCount + this.rejectedCount;
        return candidateCount == 0L ? 1.0 : (double)this.admittedCount / (double)candidateCount;
    }

    public double complexity() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.operationCount / (double)requestCount;
    }

    public double avergePenalty() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : this.totalPenalty() / (double)requestCount;
    }

    public double avergeHitPenalty() {
        return this.hitCount == 0L ? 0.0 : this.hitPenalty / (double)this.hitCount;
    }

    public double averageMissPenalty() {
        return this.missCount == 0L ? 0.0 : this.missPenalty / (double)this.missCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }
}

