/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import akka.Main;
import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.routing.ActorRefRoutee;
import akka.routing.BroadcastRoutingLogic;
import akka.routing.Routee;
import akka.routing.Router;
import akka.routing.RoutingLogic;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.Synthetic;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyActor;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.Registry;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Simulator
extends AbstractActor {
    private final TraceReader traceReader;
    private final BasicSettings settings;
    private final Stopwatch stopwatch;
    private final Reporter reporter;
    private final Router router;
    private final int batchSize;
    private int remaining;

    public Simulator() {
        Config config = this.context().system().settings().config().getConfig("caffeine.simulator");
        this.settings = new BasicSettings(config);
        this.traceReader = this.makeTraceReader();
        List<Routee> routes = this.makeRoutes();
        this.router = new Router((RoutingLogic)new BroadcastRoutingLogic(), routes);
        this.remaining = routes.size();
        this.batchSize = this.settings.batchSize();
        this.stopwatch = Stopwatch.createStarted();
        this.reporter = this.settings.report().format().create(config);
    }

    public void preStart() {
        this.self().tell((Object)Message.START, this.self());
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().matchEquals((Object)Message.START, msg -> this.broadcast()).matchEquals((Object)Message.ERROR, msg -> this.context().stop(this.self())).match(PolicyStats.class, this::reportStats).build();
    }

    private void broadcast() {
        if (this.remaining == 0) {
            this.context().system().log().error("No active policies in the current configuration");
            this.context().stop(this.self());
            return;
        }
        try (Stream<AccessEvent> events = this.traceReader.events();){
            Iterators.partition(events.iterator(), (int)this.batchSize).forEachRemaining(batch -> this.router.route(batch, this.self()));
            this.router.route((Object)Message.FINISH, this.self());
        }
        catch (Exception e) {
            this.context().system().log().error((Throwable)e, "");
            this.context().stop(this.self());
        }
    }

    private TraceReader makeTraceReader() {
        if (this.settings.isSynthetic()) {
            return Synthetic.generate(this.settings);
        }
        List<String> filePaths = this.settings.traceFiles().paths();
        TraceFormat format = this.settings.traceFiles().format();
        return format.readFiles(filePaths);
    }

    private List<Routee> makeRoutes() {
        return new Registry(this.settings, this.traceReader.characteristics()).policies().stream().map(policy -> {
            ActorRef actorRef = this.context().actorOf(Props.create(PolicyActor.class, (Object[])new Object[]{policy}));
            this.context().watch(actorRef);
            return new ActorRefRoutee(actorRef);
        }).collect(Collectors.toList());
    }

    private void reportStats(PolicyStats stats) throws IOException {
        this.reporter.add(stats);
        if (--this.remaining == 0) {
            this.reporter.print();
            this.context().stop(this.self());
            System.out.println("Executed in " + this.stopwatch);
        }
    }

    public static void main(String[] args) {
        Main.main((String[])new String[]{Simulator.class.getName()});
    }

    public static enum Message {
        START,
        FINISH,
        ERROR;

    }
}

