/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report;

import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.TextReporter;
import com.jakewharton.fliptables.FlipTable;
import com.typesafe.config.Config;
import java.util.List;

public final class TableReporter
extends TextReporter {
    public TableReporter(Config config) {
        super(config);
    }

    @Override
    protected String assemble(List<PolicyStats> results) {
        String[][] data = new String[results.size()][this.headers().length];
        for (int i = 0; i < results.size(); ++i) {
            PolicyStats policyStats = results.get(i);
            data[i] = new String[]{policyStats.name(), String.format("%.2f %%", 100.0 * policyStats.hitRate()), String.format("%,d", policyStats.hitCount()), String.format("%,d", policyStats.missCount()), String.format("%,d", policyStats.requestCount()), String.format("%,d", policyStats.evictionCount()), String.format("%.2f %%", 100.0 * policyStats.admissionRate()), String.format("%,d", policyStats.requestsWeight()), String.format("%.2f %%", 100.0 * policyStats.weightedHitRate()), String.format("%.2f", policyStats.averageMissPenalty()), String.format("%.2f", policyStats.avergePenalty()), TableReporter.steps(policyStats), policyStats.stopwatch().toString()};
        }
        return FlipTable.of((String[])this.headers(), (String[][])data);
    }

    private static String steps(PolicyStats policyStats) {
        long operations = policyStats.operationCount();
        long complexity = (long)(100.0 * policyStats.complexity());
        return operations == 0L ? "?" : String.format("%,d (%,d %%)", operations, complexity);
    }
}

