/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Locale;
import java.util.Set;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;

public final class ExpiringMapPolicy
implements Policy.KeyOnlyPolicy {
    private final ExpiringMap<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats("product.ExpiringMap");

    public ExpiringMapPolicy(Config config) {
        ExpiringMapSettings settings = new ExpiringMapSettings(config);
        this.cache = ExpiringMap.builder().expirationPolicy(settings.policy()).maxSize(settings.maximumSize()).build();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new ExpiringMapPolicy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get((Object)key);
        if (value == null) {
            if (this.cache.size() == this.cache.getMaxSize()) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, (Object)key);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class ExpiringMapSettings
    extends BasicSettings {
        public ExpiringMapSettings(Config config) {
            super(config);
        }

        public ExpirationPolicy policy() {
            String policy;
            switch (policy = this.config().getString("expiring-map.policy").toLowerCase(Locale.US)) {
                case "fifo": {
                    return ExpirationPolicy.CREATED;
                }
                case "lru": {
                    return ExpirationPolicy.ACCESSED;
                }
            }
            throw new IllegalArgumentException("Unknown policy type: " + policy);
        }
    }
}

