/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.rewrite;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.rewrite.OutputFormat;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.google.common.base.Stopwatch;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public final class Rewriter {
    @Parameter(names={"--inputFiles"}, required=true, description="The trace input files. To use a mix of formats, specify the entry as format:path, e.g. lirs:loop.trace.gz")
    private List<String> inputFiles = new ArrayList<String>();
    @Parameter(names={"--inputFormat"}, description="The default trace input format")
    private TraceFormat inputFormat = TraceFormat.LIRS;
    @Parameter(names={"--outputFile"}, description="The trace output file", required=true)
    private Path outputFile;
    @Parameter(names={"--outputFormat"}, description="The trace output format", required=true)
    private OutputFormat outputFormat;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;

    public void run() throws IOException {
        int count = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (Stream<AccessEvent> events = this.inputFormat.readFiles(this.inputFiles).events();
             BufferedWriter writer = Files.newBufferedWriter(this.outputFile, new OpenOption[0]);){
            Iterator i = events.iterator();
            while (i.hasNext()) {
                this.outputFormat.write(writer, ((AccessEvent)i.next()).key());
                ++count;
            }
        }
        System.out.printf("Rewrote %,d events in %s%n", count, stopwatch);
    }

    public static void main(String[] args) throws IOException {
        Rewriter rewriter = new Rewriter();
        JCommander commander = JCommander.newBuilder().programName(Rewriter.class.getSimpleName()).addObject((Object)rewriter).build();
        commander.parse(args);
        if (rewriter.help) {
            commander.usage();
        } else {
            rewriter.run();
        }
    }
}

