/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimber;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimberType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class HillClimberWindowTinyLfuPolicy
implements Policy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final HillClimber climber;
    private final Admittor admittor;
    private final int maximumSize;
    private final Node headWindow;
    private final Node headProbation;
    private final Node headProtected;
    private int maxWindow;
    private int maxProtected;
    private int sizeWindow;
    private int sizeProtected;
    static final boolean debug = false;
    static final boolean trace = false;

    public HillClimberWindowTinyLfuPolicy(HillClimberType strategy, double percentMain, HillClimberWindowTinyLfuSettings settings) {
        String name = String.format("sketch.HillClimberWindowTinyLfu (%s %.0f%%)", strategy.name().toLowerCase(Locale.US), 100.0 * (1.0 - percentMain));
        this.policyStats = new PolicyStats(name);
        this.admittor = new TinyLfu(settings.config(), this.policyStats);
        this.climber = strategy.create(settings.config());
        int maxMain = (int)((double)settings.maximumSize() * percentMain);
        this.maxProtected = (int)((double)maxMain * settings.percentMainProtected());
        this.maxWindow = settings.maximumSize() - maxMain;
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        this.headProtected = new Node();
        this.headProbation = new Node();
        this.headWindow = new Node();
        this.printSegmentSizes();
    }

    public static Set<Policy> policies(Config config) {
        HillClimberWindowTinyLfuSettings settings = new HillClimberWindowTinyLfuSettings(config);
        HashSet<Policy> policies = new HashSet<Policy>();
        for (HillClimberType climber : settings.strategy()) {
            for (double percentMain : settings.percentMain()) {
                policies.add(new HillClimberWindowTinyLfuPolicy(climber, percentMain, settings));
            }
        }
        return policies;
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        HillClimber.QueueType queue = null;
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else {
            queue = node.queue;
            if (queue == HillClimber.QueueType.WINDOW) {
                this.onWindowHit(node);
                this.policyStats.recordHit();
            } else if (queue == HillClimber.QueueType.PROBATION) {
                this.onProbationHit(node);
                this.policyStats.recordHit();
            } else if (queue == HillClimber.QueueType.PROTECTED) {
                this.onProtectedHit(node);
                this.policyStats.recordHit();
            } else {
                throw new IllegalStateException();
            }
        }
        this.climb(key, queue);
    }

    private void onMiss(long key) {
        Node node = new Node(key, HillClimber.QueueType.WINDOW);
        node.appendToTail(this.headWindow);
        this.data.put(key, (Object)node);
        ++this.sizeWindow;
        this.evict();
    }

    private void onWindowHit(Node node) {
        node.moveToTail(this.headWindow);
    }

    private void onProbationHit(Node node) {
        node.remove();
        node.queue = HillClimber.QueueType.PROTECTED;
        node.appendToTail(this.headProtected);
        ++this.sizeProtected;
        this.demoteProtected();
    }

    private void demoteProtected() {
        if (this.sizeProtected > this.maxProtected) {
            Node demote = this.headProtected.next;
            demote.remove();
            demote.queue = HillClimber.QueueType.PROBATION;
            demote.appendToTail(this.headProbation);
            --this.sizeProtected;
        }
    }

    private void onProtectedHit(Node node) {
        node.moveToTail(this.headProtected);
    }

    private void evict() {
        if (this.sizeWindow <= this.maxWindow) {
            return;
        }
        Node candidate = this.headWindow.next;
        --this.sizeWindow;
        candidate.remove();
        candidate.queue = HillClimber.QueueType.PROBATION;
        candidate.appendToTail(this.headProbation);
        if (this.data.size() > this.maximumSize) {
            Node victim = this.headProbation.next;
            Node evict = this.admittor.admit(candidate.key, victim.key) ? victim : candidate;
            this.data.remove(evict.key);
            evict.remove();
            this.policyStats.recordEviction();
        }
    }

    private void climb(long key, @Nullable HillClimber.QueueType queue) {
        if (this.data.size() < this.maximumSize) {
            return;
        }
        if (queue == null) {
            this.climber.onMiss(key);
        } else {
            this.climber.onHit(key, queue);
        }
        HillClimber.Adaptation adaptation = this.climber.adapt(this.sizeWindow, this.sizeProtected);
        if (adaptation.type == HillClimber.Adaptation.Type.INCREASE_WINDOW) {
            this.increaseWindow(adaptation.amount);
        } else if (adaptation.type == HillClimber.Adaptation.Type.DECREASE_WINDOW) {
            this.decreaseWindow(adaptation.amount);
        }
    }

    private void increaseWindow(int amount) {
        if (this.maxProtected == 0) {
            return;
        }
        int steps = Math.min(amount, this.maxProtected);
        for (int i = 0; i < steps; ++i) {
            ++this.maxWindow;
            ++this.sizeWindow;
            --this.maxProtected;
            this.demoteProtected();
            Node candidate = this.headProbation.next;
            candidate.remove();
            candidate.queue = HillClimber.QueueType.WINDOW;
            candidate.appendToTail(this.headWindow);
        }
    }

    private void decreaseWindow(int amount) {
        if (this.maxWindow == 0) {
            return;
        }
        int steps = Math.min(amount, this.maxWindow);
        for (int i = 0; i < steps; ++i) {
            if (amount <= 0) continue;
            --this.maxWindow;
            --this.sizeWindow;
            ++this.maxProtected;
            Node candidate = this.headWindow.next;
            candidate.remove();
            candidate.queue = HillClimber.QueueType.PROBATION;
            candidate.appendToHead(this.headProbation);
        }
    }

    private void printSegmentSizes() {
    }

    @Override
    public void finished() {
        this.printSegmentSizes();
        long windowSize = this.data.values().stream().filter(n -> n.queue == HillClimber.QueueType.WINDOW).count();
        long probationSize = this.data.values().stream().filter(n -> n.queue == HillClimber.QueueType.PROBATION).count();
        long protectedSize = this.data.values().stream().filter(n -> n.queue == HillClimber.QueueType.PROTECTED).count();
        Preconditions.checkState((windowSize == (long)this.sizeWindow ? 1 : 0) != 0);
        Preconditions.checkState((protectedSize == (long)this.sizeProtected ? 1 : 0) != 0);
        Preconditions.checkState((probationSize == (long)this.data.size() - windowSize - protectedSize ? 1 : 0) != 0);
        Preconditions.checkState((this.data.size() <= this.maximumSize ? 1 : 0) != 0);
    }

    static final class HillClimberWindowTinyLfuSettings
    extends BasicSettings {
        public HillClimberWindowTinyLfuSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("hill-climber-window-tiny-lfu.percent-main");
        }

        public double percentMainProtected() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.percent-main-protected");
        }

        public Set<HillClimberType> strategy() {
            return this.config().getStringList("hill-climber-window-tiny-lfu.strategy").stream().map(strategy -> strategy.replace('-', '_').toUpperCase(Locale.US)).map(HillClimberType::valueOf).collect(Collectors.toSet());
        }
    }

    static final class Node {
        final long key;
        HillClimber.QueueType queue;
        Node prev;
        Node next;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, HillClimber.QueueType queue) {
            this.queue = queue;
            this.key = key;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToHead(Node head) {
            Node first = head.next;
            head.next = this;
            first.prev = this;
            this.prev = head;
            this.next = first;
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("queue", (Object)this.queue).toString();
        }
    }
}

