/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.jcache.CacheProxy;
import com.github.benmanes.caffeine.jcache.Expirable;
import com.github.benmanes.caffeine.jcache.LoadingCacheProxy;
import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import com.github.benmanes.caffeine.jcache.configuration.TypesafeConfigurator;
import com.github.benmanes.caffeine.jcache.event.EventDispatcher;
import com.github.benmanes.caffeine.jcache.event.JCacheEvictionListener;
import com.github.benmanes.caffeine.jcache.integration.JCacheLoaderAdapter;
import com.github.benmanes.caffeine.jcache.management.JCacheStatisticsMXBean;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CacheFactory {
    private CacheFactory() {
    }

    public static boolean isDefinedExternally(String cacheName) {
        return TypesafeConfigurator.cacheNames(CacheFactory.rootConfig()).contains(cacheName);
    }

    public static <K, V> @Nullable CacheProxy<K, V> tryToCreateFromExternalSettings(CacheManager cacheManager, String cacheName) {
        return TypesafeConfigurator.from(CacheFactory.rootConfig(), cacheName).map(configuration -> CacheFactory.createCache(cacheManager, cacheName, configuration)).orElse(null);
    }

    public static <K, V> CacheProxy<K, V> createCache(CacheManager cacheManager, String cacheName, Configuration<K, V> configuration) {
        CaffeineConfiguration<K, V> config = CacheFactory.resolveConfigurationFor(configuration);
        return new Builder<K, V>(cacheManager, cacheName, config).build();
    }

    private static Config rootConfig() {
        return Objects.requireNonNull(TypesafeConfigurator.configSource().get());
    }

    private static <K, V> CaffeineConfiguration<K, V> resolveConfigurationFor(Configuration<K, V> configuration) {
        if (configuration instanceof CaffeineConfiguration) {
            return new CaffeineConfiguration((CaffeineConfiguration)configuration);
        }
        CaffeineConfiguration template = TypesafeConfigurator.defaults(CacheFactory.rootConfig());
        if (configuration instanceof CompleteConfiguration) {
            CompleteConfiguration complete = (CompleteConfiguration)configuration;
            template.setReadThrough(complete.isReadThrough());
            template.setWriteThrough(complete.isWriteThrough());
            template.setManagementEnabled(complete.isManagementEnabled());
            template.setStatisticsEnabled(complete.isStatisticsEnabled());
            template.getCacheEntryListenerConfigurations().forEach(template::removeCacheEntryListenerConfiguration);
            complete.getCacheEntryListenerConfigurations().forEach(template::addCacheEntryListenerConfiguration);
            template.setCacheLoaderFactory(complete.getCacheLoaderFactory());
            template.setCacheWriterFactory(complete.getCacheWriterFactory());
            template.setExpiryPolicyFactory((Factory<ExpiryPolicy>)complete.getExpiryPolicyFactory());
        }
        template.setTypes(configuration.getKeyType(), configuration.getValueType());
        template.setStoreByValue(configuration.isStoreByValue());
        return template;
    }

    private static final class Builder<K, V> {
        final Ticker ticker;
        final String cacheName;
        final Executor executor;
        final CacheManager cacheManager;
        final ExpiryPolicy expiryPolicy;
        final EventDispatcher<K, V> dispatcher;
        final JCacheStatisticsMXBean statistics;
        final Caffeine<Object, Object> caffeine;
        final CaffeineConfiguration<K, V> config;

        Builder(CacheManager cacheManager, String cacheName, CaffeineConfiguration<K, V> config) {
            this.config = config;
            this.cacheName = cacheName;
            this.cacheManager = cacheManager;
            this.caffeine = Caffeine.newBuilder();
            this.statistics = new JCacheStatisticsMXBean();
            this.ticker = (Ticker)config.getTickerFactory().create();
            this.executor = (Executor)config.getExecutorFactory().create();
            this.expiryPolicy = (ExpiryPolicy)config.getExpiryPolicyFactory().create();
            this.dispatcher = new EventDispatcher(this.executor);
            this.caffeine.ticker(this.ticker);
            this.caffeine.executor(this.executor);
            config.getCacheEntryListenerConfigurations().forEach(this.dispatcher::register);
        }

        public CacheProxy<K, V> build() {
            CacheProxy<K, V> cache;
            boolean evicts = false;
            evicts |= this.configureMaximumSize();
            evicts |= this.configureMaximumWeight();
            evicts |= this.configureExpireAfterWrite();
            evicts |= this.configureExpireAfterAccess();
            evicts |= this.configureExpireVariably();
            if (this.config.isNativeStatisticsEnabled()) {
                this.caffeine.recordStats();
            }
            JCacheEvictionListener<K, V> evictionListener = null;
            if (evicts) {
                evictionListener = new JCacheEvictionListener<K, V>(this.dispatcher, this.statistics);
                this.caffeine.writer(evictionListener);
            }
            if (this.isReadThrough()) {
                this.configureRefreshAfterWrite();
                cache = this.newLoadingCacheProxy();
            } else {
                cache = this.newCacheProxy();
            }
            if (evictionListener != null) {
                evictionListener.setCache(cache);
            }
            return cache;
        }

        private boolean isReadThrough() {
            return this.config.isReadThrough() && this.config.getCacheLoaderFactory() != null;
        }

        private CacheProxy<K, V> newCacheProxy() {
            Optional cacheLoader = Optional.ofNullable(this.config.getCacheLoaderFactory()).map(Factory::create);
            return new CacheProxy<K, V>(this.cacheName, this.executor, this.cacheManager, this.config, this.caffeine.build(), this.dispatcher, cacheLoader, this.expiryPolicy, this.ticker, this.statistics);
        }

        private CacheProxy<K, V> newLoadingCacheProxy() {
            CacheLoader cacheLoader = (CacheLoader)this.config.getCacheLoaderFactory().create();
            JCacheLoaderAdapter<K, V> adapter = new JCacheLoaderAdapter<K, V>(cacheLoader, this.dispatcher, this.expiryPolicy, this.ticker, this.statistics);
            LoadingCacheProxy<K, V> cache = new LoadingCacheProxy<K, V>(this.cacheName, this.executor, this.cacheManager, this.config, this.caffeine.build(adapter), this.dispatcher, cacheLoader, this.expiryPolicy, this.ticker, this.statistics);
            adapter.setCache(cache);
            return cache;
        }

        private boolean configureMaximumSize() {
            if (this.config.getMaximumSize().isPresent()) {
                this.caffeine.maximumSize(this.config.getMaximumSize().getAsLong());
            }
            return this.config.getMaximumSize().isPresent();
        }

        private boolean configureMaximumWeight() {
            if (this.config.getMaximumWeight().isPresent()) {
                this.caffeine.maximumWeight(this.config.getMaximumWeight().getAsLong());
                Weigher weigher = this.config.getWeigherFactory().map(Factory::create).orElseThrow(() -> new IllegalStateException("Weigher not configured"));
                this.caffeine.weigher((key, expirable) -> weigher.weigh(key, expirable.get()));
            }
            return this.config.getMaximumWeight().isPresent();
        }

        private boolean configureExpireAfterWrite() {
            if (this.config.getExpireAfterWrite().isPresent()) {
                this.caffeine.expireAfterWrite(this.config.getExpireAfterWrite().getAsLong(), TimeUnit.NANOSECONDS);
            }
            return this.config.getExpireAfterWrite().isPresent();
        }

        private boolean configureExpireAfterAccess() {
            if (this.config.getExpireAfterAccess().isPresent()) {
                this.caffeine.expireAfterAccess(this.config.getExpireAfterAccess().getAsLong(), TimeUnit.NANOSECONDS);
            }
            return this.config.getExpireAfterAccess().isPresent();
        }

        private boolean configureExpireVariably() {
            this.config.getExpiryFactory().ifPresent(factory -> {
                final Expiry expiry = (Expiry)factory.create();
                this.caffeine.expireAfter(new Expiry<K, Expirable<V>>(){

                    public long expireAfterCreate(K key, Expirable<V> expirable, long currentTime) {
                        return expiry.expireAfterCreate(key, expirable.get(), currentTime);
                    }

                    public long expireAfterUpdate(K key, Expirable<V> expirable, long currentTime, long currentDuration) {
                        return expiry.expireAfterUpdate(key, expirable.get(), currentTime, currentDuration);
                    }

                    public long expireAfterRead(K key, Expirable<V> expirable, long currentTime, long currentDuration) {
                        return expiry.expireAfterRead(key, expirable.get(), currentTime, currentDuration);
                    }
                });
            });
            return this.config.getExpireAfterWrite().isPresent();
        }

        private void configureRefreshAfterWrite() {
            if (this.config.getRefreshAfterWrite().isPresent()) {
                this.caffeine.refreshAfterWrite(this.config.getRefreshAfterWrite().getAsLong(), TimeUnit.NANOSECONDS);
            }
        }
    }
}

