/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.rtftohtml.impl;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bbottema.rtftohtml.RTF2HTMLConverter;
import org.bbottema.rtftohtml.impl.util.ByteUtil;
import org.bbottema.rtftohtml.impl.util.CharsetHelper;
import org.jetbrains.annotations.NotNull;

public class RTF2HTMLConverterClassic
implements RTF2HTMLConverter {
    public static final RTF2HTMLConverter INSTANCE = new RTF2HTMLConverterClassic();
    private static final String[] HTML_START_TAGS = new String[]{"<html", "<Html", "<HTML"};
    private static final String[] HTML_END_TAGS = new String[]{"</html>", "</Html>", "</HTML>"};

    private RTF2HTMLConverterClassic() {
    }

    @Override
    @NotNull
    public String rtf2html(@NotNull String rtf) {
        if (rtf == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.rtf2html must not be null");
        }
        Charset charset = this.extractCodepage(rtf);
        String plain = this.fetchHtmlSection(rtf);
        plain = this.replaceSpecialSequences(plain);
        plain = this.replaceHexSequences(plain, "(?:\\\\f\\d(?:\\\\'..)+)", CharsetHelper.WINDOWS_CHARSET);
        plain = this.replaceHexSequences(plain, "(?:\\\\'..)+", charset);
        plain = this.cleanupRemainingSequences(plain);
        String string = plain = this.replaceLineBreaks(plain);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.rtf2html must not return null");
        }
        return string;
    }

    private String cleanupRemainingSequences(String plain) {
        if (plain == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.cleanupRemainingSequences must not be null");
        }
        String string = plain.replaceAll("(\\\\f\\d.+?;)+", "").replaceAll("\\\\\\S+", "").replaceAll("BM__MailAutoSig((?s).*?(?-s))BM__MailAutoSig", "$1");
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.cleanupRemainingSequences must not return null");
        }
        return string;
    }

    private Charset extractCodepage(String rtf) {
        if (rtf == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.extractCodepage must not be null");
        }
        Matcher codePageMatcher = Pattern.compile("(?:\\\\ansicpg(?<codePage>.+?)\\\\)+").matcher(rtf);
        if (codePageMatcher.find()) {
            Charset charset = CharsetHelper.findCharset(codePageMatcher.group("codePage"));
            if (charset == null) {
                throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.extractCodepage must not return null");
            }
            return charset;
        }
        Charset charset = CharsetHelper.WINDOWS_CHARSET;
        if (charset == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.extractCodepage must not return null");
        }
        return charset;
    }

    private String replaceLineBreaks(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.replaceLineBreaks must not be null");
        }
        String string = text.replaceAll("( <br/> ( <br/> )+)", " <br/> ").replaceAll("\\r\\n", "\n").replaceAll("[\\r\\u0000]", "");
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.replaceLineBreaks must not return null");
        }
        return string;
    }

    private String replaceHexSequences(String text, String sequencesToMatch, Charset charset) {
        if (text == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.replaceHexSequences must not be null");
        }
        if (sequencesToMatch == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.replaceHexSequences must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.replaceHexSequences must not be null");
        }
        StringBuilder res = new StringBuilder();
        int lastPosition = 0;
        Matcher escapedHexGroupMatcher = Pattern.compile(sequencesToMatch).matcher(text);
        while (escapedHexGroupMatcher.find()) {
            res.append(text, lastPosition, escapedHexGroupMatcher.start());
            StringBuilder hexText = new StringBuilder();
            String escapedHexGroup = escapedHexGroupMatcher.group(0);
            Matcher unescapedHexCharacterMatcher = Pattern.compile("\\\\'(..)").matcher(escapedHexGroup);
            while (unescapedHexCharacterMatcher.find()) {
                hexText.append(unescapedHexCharacterMatcher.group(1));
            }
            res.append(ByteUtil.hexToString(hexText.toString(), charset));
            lastPosition = escapedHexGroupMatcher.end();
        }
        if (res.length() == 0) {
            res.append(text);
        } else {
            res.append(text, lastPosition, text.length());
        }
        String string = res.toString();
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.replaceHexSequences must not return null");
        }
        return string;
    }

    private String fetchHtmlSection(String text) {
        int i;
        if (text == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.fetchHtmlSection must not be null");
        }
        int htmlStart = -1;
        int htmlEnd = -1;
        for (i = 0; i < HTML_START_TAGS.length && htmlStart < 0; ++i) {
            htmlStart = text.indexOf(HTML_START_TAGS[i]);
        }
        for (i = 0; i < HTML_END_TAGS.length && htmlEnd < 0; ++i) {
            htmlEnd = text.indexOf(HTML_END_TAGS[i]);
            if (htmlEnd <= 0) continue;
            htmlEnd += HTML_END_TAGS[i].length();
        }
        if (htmlStart > -1 && htmlEnd > -1) {
            String string = text.substring(htmlStart, htmlEnd + 1);
            if (string == null) {
                throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.fetchHtmlSection must not return null");
            }
            return string;
        }
        String html = "<html><body style=\"font-family:'Courier',monospace;font-size:10pt;\">" + text + "</body></html>";
        html = html.replaceAll("[\\n\\r]+", " ");
        html = html.replaceAll("(http://\\S+)", "<a href=\"$1\">$1</a>");
        String string = html.replaceAll("mailto:(\\S+@\\S+)", "<a href=\"mailto:$1\">$1</a>");
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.fetchHtmlSection must not return null");
        }
        return string;
    }

    private String replaceSpecialSequences(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.replaceSpecialSequences must not be null");
        }
        String replacedText = text;
        replacedText = replacedText.replaceAll("\\{\\\\S+ [^\\s\\\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{HYPERLINK[^\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{\\\\pntext[^\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{\\\\\\*\\\\htmltag\\d+ (&[#\\w]+;)}\\\\htmlrtf.*\\\\htmlrtf0 ", "$1");
        replacedText = replacedText.replaceAll("([^\\\\])\\}+", "$1");
        replacedText = replacedText.replaceAll("([^\\\\])\\{+", "$1");
        replacedText = replacedText.replaceAll("\\\\\\}", "}");
        replacedText = replacedText.replaceAll("\\\\\\{", "{");
        replacedText = replacedText.replaceAll("\\\\pard*", "\n");
        replacedText = replacedText.replaceAll("\\\\tab", "\t");
        String string = replacedText = replacedText.replaceAll("\\\\\\*\\\\\\S+", "");
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterClassic.replaceSpecialSequences must not return null");
        }
        return string;
    }
}

