/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.clusteredobjectpool.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.bbottema.clusteredobjectpool.core.api.AllocatorFactory;
import org.bbottema.clusteredobjectpool.core.api.LoadBalancingStrategy;
import org.bbottema.clusteredobjectpool.cyclingstrategies.RoundRobinLoadBalancing;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.util.ForeverTimeout;
import org.bbottema.genericobjectpool.util.Timeout;
import org.jetbrains.annotations.NotNull;

@SuppressFBWarnings(justification="Generated code")
public final class ClusterConfig<PoolKey, T> {
    @NotNull
    private final AllocatorFactory<PoolKey, T> allocatorFactory;
    @NotNull
    private final ExpirationPolicy<T> defaultExpirationPolicy;
    private final int defaultMaxPoolSize;
    private final int defaultCorePoolSize;
    @NotNull
    private final Timeout claimTimeout;
    @NotNull
    private final LoadBalancingStrategy loadBalancingStrategy;

    private static <PoolKey, T> int $default$defaultMaxPoolSize() {
        return 0;
    }

    private static <PoolKey, T> int $default$defaultCorePoolSize() {
        return 0;
    }

    private static <PoolKey, T> Timeout $default$claimTimeout() {
        return ForeverTimeout.WAIT_FOREVER;
    }

    private static <PoolKey, T> LoadBalancingStrategy $default$loadBalancingStrategy() {
        return new RoundRobinLoadBalancing();
    }

    public static <PoolKey, T> ClusterConfigBuilder<PoolKey, T> builder() {
        return new ClusterConfigBuilder();
    }

    public AllocatorFactory<PoolKey, T> getAllocatorFactory() {
        return this.allocatorFactory;
    }

    public ExpirationPolicy<T> getDefaultExpirationPolicy() {
        return this.defaultExpirationPolicy;
    }

    public int getDefaultMaxPoolSize() {
        return this.defaultMaxPoolSize;
    }

    public int getDefaultCorePoolSize() {
        return this.defaultCorePoolSize;
    }

    public Timeout getClaimTimeout() {
        return this.claimTimeout;
    }

    public LoadBalancingStrategy getLoadBalancingStrategy() {
        return this.loadBalancingStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterConfig)) {
            return false;
        }
        ClusterConfig other = (ClusterConfig)o;
        AllocatorFactory<PoolKey, T> this$allocatorFactory = this.getAllocatorFactory();
        AllocatorFactory<PoolKey, T> other$allocatorFactory = other.getAllocatorFactory();
        if (this$allocatorFactory == null ? other$allocatorFactory != null : !this$allocatorFactory.equals(other$allocatorFactory)) {
            return false;
        }
        ExpirationPolicy<T> this$defaultExpirationPolicy = this.getDefaultExpirationPolicy();
        ExpirationPolicy<T> other$defaultExpirationPolicy = other.getDefaultExpirationPolicy();
        if (this$defaultExpirationPolicy == null ? other$defaultExpirationPolicy != null : !this$defaultExpirationPolicy.equals(other$defaultExpirationPolicy)) {
            return false;
        }
        if (this.getDefaultMaxPoolSize() != other.getDefaultMaxPoolSize()) {
            return false;
        }
        if (this.getDefaultCorePoolSize() != other.getDefaultCorePoolSize()) {
            return false;
        }
        Timeout this$claimTimeout = this.getClaimTimeout();
        Timeout other$claimTimeout = other.getClaimTimeout();
        if (this$claimTimeout == null ? other$claimTimeout != null : !this$claimTimeout.equals(other$claimTimeout)) {
            return false;
        }
        LoadBalancingStrategy this$loadBalancingStrategy = this.getLoadBalancingStrategy();
        LoadBalancingStrategy other$loadBalancingStrategy = other.getLoadBalancingStrategy();
        return !(this$loadBalancingStrategy == null ? other$loadBalancingStrategy != null : !this$loadBalancingStrategy.equals(other$loadBalancingStrategy));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AllocatorFactory<PoolKey, T> $allocatorFactory = this.getAllocatorFactory();
        result = result * 59 + ($allocatorFactory == null ? 43 : $allocatorFactory.hashCode());
        ExpirationPolicy<T> $defaultExpirationPolicy = this.getDefaultExpirationPolicy();
        result = result * 59 + ($defaultExpirationPolicy == null ? 43 : $defaultExpirationPolicy.hashCode());
        result = result * 59 + this.getDefaultMaxPoolSize();
        result = result * 59 + this.getDefaultCorePoolSize();
        Timeout $claimTimeout = this.getClaimTimeout();
        result = result * 59 + ($claimTimeout == null ? 43 : $claimTimeout.hashCode());
        LoadBalancingStrategy $loadBalancingStrategy = this.getLoadBalancingStrategy();
        result = result * 59 + ($loadBalancingStrategy == null ? 43 : $loadBalancingStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "ClusterConfig(allocatorFactory=" + this.getAllocatorFactory() + ", defaultExpirationPolicy=" + this.getDefaultExpirationPolicy() + ", defaultMaxPoolSize=" + this.getDefaultMaxPoolSize() + ", defaultCorePoolSize=" + this.getDefaultCorePoolSize() + ", claimTimeout=" + this.getClaimTimeout() + ", loadBalancingStrategy=" + this.getLoadBalancingStrategy() + ")";
    }

    private ClusterConfig(AllocatorFactory<PoolKey, T> allocatorFactory, ExpirationPolicy<T> defaultExpirationPolicy, int defaultMaxPoolSize, int defaultCorePoolSize, Timeout claimTimeout, LoadBalancingStrategy loadBalancingStrategy) {
        this.allocatorFactory = allocatorFactory;
        this.defaultExpirationPolicy = defaultExpirationPolicy;
        this.defaultMaxPoolSize = defaultMaxPoolSize;
        this.defaultCorePoolSize = defaultCorePoolSize;
        this.claimTimeout = claimTimeout;
        this.loadBalancingStrategy = loadBalancingStrategy;
    }

    public static class ClusterConfigBuilder<PoolKey, T> {
        private AllocatorFactory<PoolKey, T> allocatorFactory;
        private ExpirationPolicy<T> defaultExpirationPolicy;
        private boolean defaultMaxPoolSize$set;
        private int defaultMaxPoolSize;
        private boolean defaultCorePoolSize$set;
        private int defaultCorePoolSize;
        private boolean claimTimeout$set;
        private Timeout claimTimeout;
        private boolean loadBalancingStrategy$set;
        private LoadBalancingStrategy loadBalancingStrategy;

        ClusterConfigBuilder() {
        }

        public ClusterConfigBuilder<PoolKey, T> allocatorFactory(AllocatorFactory<PoolKey, T> allocatorFactory) {
            this.allocatorFactory = allocatorFactory;
            return this;
        }

        public ClusterConfigBuilder<PoolKey, T> defaultExpirationPolicy(ExpirationPolicy<T> defaultExpirationPolicy) {
            this.defaultExpirationPolicy = defaultExpirationPolicy;
            return this;
        }

        public ClusterConfigBuilder<PoolKey, T> defaultMaxPoolSize(int defaultMaxPoolSize) {
            this.defaultMaxPoolSize = defaultMaxPoolSize;
            this.defaultMaxPoolSize$set = true;
            return this;
        }

        public ClusterConfigBuilder<PoolKey, T> defaultCorePoolSize(int defaultCorePoolSize) {
            this.defaultCorePoolSize = defaultCorePoolSize;
            this.defaultCorePoolSize$set = true;
            return this;
        }

        public ClusterConfigBuilder<PoolKey, T> claimTimeout(Timeout claimTimeout) {
            this.claimTimeout = claimTimeout;
            this.claimTimeout$set = true;
            return this;
        }

        public ClusterConfigBuilder<PoolKey, T> loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.loadBalancingStrategy = loadBalancingStrategy;
            this.loadBalancingStrategy$set = true;
            return this;
        }

        public ClusterConfig<PoolKey, T> build() {
            int defaultMaxPoolSize = this.defaultMaxPoolSize;
            if (!this.defaultMaxPoolSize$set) {
                defaultMaxPoolSize = ClusterConfig.$default$defaultMaxPoolSize();
            }
            int defaultCorePoolSize = this.defaultCorePoolSize;
            if (!this.defaultCorePoolSize$set) {
                defaultCorePoolSize = ClusterConfig.$default$defaultCorePoolSize();
            }
            Timeout claimTimeout = this.claimTimeout;
            if (!this.claimTimeout$set) {
                claimTimeout = ClusterConfig.$default$claimTimeout();
            }
            LoadBalancingStrategy loadBalancingStrategy = this.loadBalancingStrategy;
            if (!this.loadBalancingStrategy$set) {
                loadBalancingStrategy = ClusterConfig.$default$loadBalancingStrategy();
            }
            return new ClusterConfig(this.allocatorFactory, this.defaultExpirationPolicy, defaultMaxPoolSize, defaultCorePoolSize, claimTimeout, loadBalancingStrategy);
        }

        public String toString() {
            return "ClusterConfig.ClusterConfigBuilder(allocatorFactory=" + this.allocatorFactory + ", defaultExpirationPolicy=" + this.defaultExpirationPolicy + ", defaultMaxPoolSize=" + this.defaultMaxPoolSize + ", defaultCorePoolSize=" + this.defaultCorePoolSize + ", claimTimeout=" + this.claimTimeout + ", loadBalancingStrategy=" + this.loadBalancingStrategy + ")";
        }
    }
}

