/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.vhs;

import com.github.axet.vget.info.VideoFileInfo;
import com.github.axet.vget.info.VideoInfo;
import com.github.axet.vget.vhs.YouTubeInfo;
import com.github.axet.vget.vhs.YouTubeParser;
import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class YouTubeQParser
extends YouTubeParser {
    YouTubeInfo.YoutubeQuality q;

    public YouTubeQParser(YouTubeInfo.YoutubeQuality q) {
        this.q = q;
    }

    @Override
    public List<VideoFileInfo> extract(VideoInfo vinfo, AtomicBoolean stop, Runnable notify) {
        List<YouTubeParser.VideoDownload> sNextVideoURL = this.extractLinks((YouTubeInfo)vinfo, stop, notify);
        if (sNextVideoURL.size() == 0) {
            throw new DownloadRetry("empty video download list, wait until youtube will process the video");
        }
        Collections.sort(sNextVideoURL, new YouTubeParser.VideoContentFirst());
        int i = 0;
        while (i < sNextVideoURL.size()) {
            YouTubeParser.VideoDownload v = sNextVideoURL.get(i);
            boolean found = true;
            YouTubeInfo.StreamCombined vq = (YouTubeInfo.StreamCombined)v.stream;
            if (found &= this.q.equals((Object)vq.vq)) {
                YouTubeInfo yinfo = (YouTubeInfo)vinfo;
                yinfo.setStreamInfo(vq);
                VideoFileInfo info = new VideoFileInfo(v.url);
                vinfo.setInfo(Arrays.asList(info));
                vinfo.setSource(v.url);
                return vinfo.getInfo();
            }
            ++i;
        }
        throw new DownloadError("no video user quality found");
    }
}

