/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget;

import com.github.axet.threads.LimitThreadPool;
import com.github.axet.vget.info.VGetParser;
import com.github.axet.vget.info.VideoFileInfo;
import com.github.axet.vget.info.VideoInfo;
import com.github.axet.vget.vhs.VimeoParser;
import com.github.axet.vget.vhs.YouTubeParser;
import com.github.axet.wget.Direct;
import com.github.axet.wget.DirectMultipart;
import com.github.axet.wget.DirectRange;
import com.github.axet.wget.DirectSingle;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadIOCodeError;
import com.github.axet.wget.info.ex.DownloadIOError;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import com.github.axet.wget.info.ex.DownloadMultipartError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class VGet {
    protected VideoInfo info;
    protected File targetDir;
    protected File targetForce = null;

    public VGet(URL source) {
        this(source, null);
    }

    public VGet(URL source, File targetDir) {
        this(VGet.parser(null, source).info(source), targetDir);
    }

    public VGet(VideoInfo info, File targetDir) {
        this.info = info;
        this.targetDir = targetDir;
    }

    public VGet(VideoInfo info) {
        this.info = info;
    }

    public void setTarget(File file) {
        this.targetForce = file;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public VideoInfo getVideo() {
        return this.info;
    }

    public void download() {
        this.download(null, new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void download(VGetParser user) {
        this.download(user, new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public static String replaceBadChars(String f) {
        String ff;
        String replace = " ";
        f = f.replaceAll("/", replace);
        f = f.replaceAll("\\\\", replace);
        f = f.replaceAll(":", replace);
        f = f.replaceAll("\\?", replace);
        f = f.replaceAll("\\\"", replace);
        f = f.replaceAll("\\*", replace);
        f = f.replaceAll("<", replace);
        f = f.replaceAll(">", replace);
        f = f.replaceAll("\\|", replace);
        f = f.trim();
        f = StringUtils.removeEnd((String)f, (String)".");
        f = f.trim();
        while (!(ff = f.replaceAll("  ", " ")).equals(f)) {
            f = ff;
        }
        return f;
    }

    public static String maxFileNameLength(String str) {
        int max = 255;
        if (str.length() > max) {
            str = str.substring(0, max);
        }
        return str;
    }

    public boolean done(AtomicBoolean stop) {
        if (stop.get()) {
            throw new DownloadInterruptedError("stop");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new DownloadInterruptedError("interrupted");
        }
        return false;
    }

    public VideoFileInfo getNewInfo(List<VideoFileInfo> infoList, VideoFileInfo infoOld) {
        if (infoOld == null) {
            return null;
        }
        for (VideoFileInfo d : infoList) {
            if (!infoOld.resume(d)) continue;
            return d;
        }
        return null;
    }

    public void retry(VGetParser user, AtomicBoolean stop, Runnable notify, Throwable e) {
        boolean retracted = false;
        while (!retracted) {
            int i = RetryWrap.RETRY_DELAY;
            while (i >= 0) {
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new DownloadInterruptedError("interrupted");
                }
                this.info.setRetrying(i, e);
                notify.run();
                try {
                    Thread.sleep(RetryWrap.RETRY_SLEEP);
                }
                catch (InterruptedException ee) {
                    throw new DownloadInterruptedError((Throwable)ee);
                }
                --i;
            }
            try {
                List<VideoFileInfo> infoOldList = this.info.getInfo();
                user = VGet.parser(user, this.info.getWeb());
                user.info(this.info, stop, notify);
                if (infoOldList != null) {
                    List<VideoFileInfo> infoNewList = this.info.getInfo();
                    for (VideoFileInfo infoOld : infoOldList) {
                        VideoFileInfo infoNew = this.getNewInfo(infoNewList, infoOld);
                        if (infoOld != null && infoNew != null && infoOld.resume(infoNew)) {
                            infoNew.copy(infoOld);
                            continue;
                        }
                        if (infoOld.targetFile == null) continue;
                        FileUtils.deleteQuietly((File)infoOld.targetFile);
                        infoOld.targetFile = null;
                    }
                }
                retracted = true;
            }
            catch (DownloadIOCodeError ee) {
                if (this.retry(ee)) {
                    this.info.setState(VideoInfo.States.RETRYING, ee);
                    notify.run();
                    continue;
                }
                throw ee;
            }
            catch (DownloadRetry ee) {
                this.info.setState(VideoInfo.States.RETRYING, ee);
                notify.run();
            }
        }
    }

    public String getExt(DownloadInfo dinfo) {
        String ct = dinfo.getContentType();
        if (ct == null) {
            throw new DownloadRetry("null content type");
        }
        ct = ct.replaceFirst("video/", "");
        ct = ct.replaceFirst("audio/", "");
        return "." + ct.replaceAll("x-", "").toLowerCase();
    }

    public String getContentExt(DownloadInfo dinfo) {
        String ct = dinfo.getContentType();
        if (ct == null) {
            throw new DownloadRetry("null content type");
        }
        ct = ct.replaceFirst("/", ".");
        return "." + ct.replaceAll("x-", "").toLowerCase();
    }

    public boolean exists(File f, AtomicBoolean conflict) {
        if (f.exists()) {
            return true;
        }
        for (VideoFileInfo dinfo : this.info.getInfo()) {
            if (dinfo.targetFile == null || !dinfo.targetFile.equals(f)) continue;
            if (conflict != null) {
                conflict.set(true);
            }
            return true;
        }
        return false;
    }

    public void targetFileForce(VideoFileInfo dinfo) {
        if (this.targetForce != null) {
            if (this.exists(this.targetForce, null)) {
                throw new DownloadError("Do not use setTarget file on multiply source download");
            }
            dinfo.targetFile = this.targetForce;
            if (dinfo.multipart()) {
                if (!DirectMultipart.canResume((DownloadInfo)dinfo, (File)dinfo.targetFile)) {
                    FileUtils.deleteQuietly((File)dinfo.targetFile);
                    dinfo.reset();
                }
            } else if (dinfo.getRange()) {
                if (!DirectRange.canResume((DownloadInfo)dinfo, (File)dinfo.targetFile)) {
                    FileUtils.deleteQuietly((File)dinfo.targetFile);
                    dinfo.reset();
                }
            } else if (!DirectSingle.canResume((DownloadInfo)dinfo, (File)dinfo.targetFile)) {
                FileUtils.deleteQuietly((File)dinfo.targetFile);
                dinfo.reset();
            }
        }
    }

    public void targetFileExt(VideoFileInfo dinfo, String ext, AtomicBoolean conflict) {
        if (dinfo.targetFile == null) {
            File f;
            if (this.targetDir == null) {
                throw new RuntimeException("Set download file or directory first");
            }
            Integer idupcount = 0;
            String sfilename = VGet.replaceBadChars(this.info.getTitle());
            sfilename = VGet.maxFileNameLength(sfilename);
            do {
                String add = idupcount > 0 ? " (".concat(idupcount.toString()).concat(")") : "";
                f = new File(this.targetDir, String.valueOf(sfilename) + add + ext);
                idupcount = idupcount + 1;
            } while (this.exists(f, conflict));
            dinfo.targetFile = f;
            dinfo.reset();
        }
    }

    public void targetFile(VideoFileInfo dinfo, String ext, AtomicBoolean conflict) {
        this.targetFileForce(dinfo);
        this.targetFileExt(dinfo, ext, conflict);
    }

    public boolean retry(Throwable e) {
        if (e == null) {
            return true;
        }
        if (e instanceof DownloadIOCodeError) {
            DownloadIOCodeError c = (DownloadIOCodeError)e;
            switch (c.getCode()) {
                case 403: 
                case 416: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean empty() {
        return this.getVideo().empty();
    }

    public void extract() {
        this.extract(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void extract(AtomicBoolean stop, Runnable notify) {
        this.extract(null, stop, notify);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extract(VGetParser user, AtomicBoolean stop, Runnable notify) {
        try {
            while (true) lbl-1000:
            // 5 sources

            {
                if (this.done(stop)) {
                    return;
                }
                try {
                    if (this.info.empty() == false) return;
                    this.info.setState(VideoInfo.States.EXTRACTING);
                    user = VGet.parser(user, this.info.getWeb());
                    user.info(this.info, stop, notify);
                    this.info.setState(VideoInfo.States.EXTRACTING_DONE);
                    notify.run();
                    return;
                }
                catch (DownloadRetry e) {
                    this.retry(user, stop, notify, e);
                }
                catch (DownloadMultipartError e) {
                    this.checkFileNotFound(e);
                    this.checkRetry(e);
                    this.retry(user, stop, notify, e);
                }
                catch (DownloadIOCodeError e) {
                    if (this.retry(e) == false) throw e;
                    this.retry(user, stop, notify, e);
                }
                catch (DownloadIOError e) {
                    this.retry(user, stop, notify, e);
                    continue;
                }
                break;
            }
        }
        catch (DownloadInterruptedError e) {
            this.info.setState(VideoInfo.States.STOP);
            notify.run();
            throw e;
        }
        ** GOTO lbl-1000
    }

    void checkRetry(DownloadMultipartError e) {
        for (DownloadInfo.Part ee : e.getInfo().getParts()) {
            if (this.retry(ee.getException())) continue;
            throw e;
        }
    }

    void checkFileNotFound(DownloadMultipartError e) {
        FileNotFoundException f = null;
        for (DownloadInfo.Part ee : e.getInfo().getParts()) {
            if (ee.getException() == null) continue;
            if (ee.getException().getCause() == null) {
                return;
            }
            if (!(ee.getException().getCause() instanceof FileNotFoundException)) break;
            if (f == null) {
                f = (FileNotFoundException)ee.getException().getCause();
                continue;
            }
            FileNotFoundException ff = (FileNotFoundException)ee.getException().getCause();
            if (ff.getMessage().equals(f.getMessage())) continue;
            return;
        }
        if (f != null) {
            throw new DownloadError(f);
        }
    }

    public void download(AtomicBoolean stop, Runnable notify) {
        this.download(null, stop, notify);
    }

    /*
     * Unable to fully structure code
     */
    public void download(VGetParser user, AtomicBoolean stop, final Runnable notify) {
        try {
            if (this.empty()) {
                this.extract(user, stop, notify);
            }
            while (!this.done(stop)) {
                try {
                    block34: {
                        dinfoList = this.info.getInfo();
                        l = new LimitThreadPool(4);
                        main = Thread.currentThread();
                        targetNull = new ArrayList<VideoFileInfo>();
                        for (VideoFileInfo dinfo : dinfoList) {
                            if (dinfo.targetFile == null) {
                                targetNull.add(dinfo);
                            }
                            if ((c = dinfo.getContentType()) == null) {
                                c = "";
                            }
                            v = c.contains("video/");
                            a = c.contains("audio/");
                            if (v || a) continue;
                            throw new DownloadRetry("unable to download video, bad content " + dinfo.getContentType());
                        }
                        conflict = new AtomicBoolean(false);
                        for (VideoFileInfo dinfo : targetNull) {
                            dinfo.targetFile = null;
                            this.targetFile(dinfo, this.getExt(dinfo), (AtomicBoolean)conflict);
                        }
                        if (conflict.get()) {
                            conflict = new AtomicBoolean(false);
                            for (VideoFileInfo dinfo : targetNull) {
                                dinfo.targetFile = null;
                                this.targetFile(dinfo, this.getContentExt(dinfo), (AtomicBoolean)conflict);
                            }
                        }
                        for (final VideoFileInfo dinfo : dinfoList) {
                            if (dinfo.targetFile == null) {
                                throw new RuntimeException("bad target");
                            }
                            if (dinfo.multipart()) {
                                directV = new DirectMultipart((DownloadInfo)dinfo, dinfo.targetFile);
                            } else if (dinfo.getRange()) {
                                if (dinfo.targetFile.exists() && dinfo.targetFile.length() != dinfo.getCount()) {
                                    dinfo.targetFile = null;
                                }
                                directV = new DirectRange((DownloadInfo)dinfo, dinfo.targetFile);
                            } else {
                                directV = new DirectSingle((DownloadInfo)dinfo, dinfo.targetFile);
                            }
                            direct = directV;
                            r = new Runnable(){

                                @Override
                                public void run() {
                                    switch (dinfo.getState()) {
                                        case DOWNLOADING: {
                                            VGet.this.info.setState(VideoInfo.States.DOWNLOADING);
                                            notify.run();
                                            break;
                                        }
                                        case RETRYING: {
                                            VGet.this.info.setRetrying(dinfo.getDelay(), dinfo.getException());
                                            notify.run();
                                        }
                                    }
                                }
                            };
                            try {
                                l.blockExecute(new Runnable((Direct)direct, stop, r, main){
                                    private final /* synthetic */ Direct val$direct;
                                    private final /* synthetic */ AtomicBoolean val$stop;
                                    private final /* synthetic */ Runnable val$r;
                                    private final /* synthetic */ Thread val$main;
                                    {
                                        this.val$direct = direct;
                                        this.val$stop = atomicBoolean;
                                        this.val$r = runnable;
                                        this.val$main = thread;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            this.val$direct.download(this.val$stop, this.val$r);
                                        }
                                        catch (DownloadInterruptedError e) {
                                            this.val$main.interrupt();
                                        }
                                    }
                                });
                                continue;
                            }
                            catch (InterruptedException e) {
                                l.interrupt();
                                clear = true;
                                ** while (clear)
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    l.join();
                                    clear = false;
                                }
                                catch (InterruptedException var14_25) {
                                    // empty catch block
                                }
                                continue;
                            }
lbl59:
                            // 1 sources

                            throw new DownloadInterruptedError((Throwable)e);
                        }
                        try {
                            l.waitUntilTermination();
                            break block34;
                        }
                        catch (InterruptedException e) {
                            l.interrupt();
                            clear = true;
                            ** while (clear)
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                l.join();
                                clear = false;
                            }
                            catch (InterruptedException var9_16) {
                                // empty catch block
                            }
                            continue;
                        }
lbl74:
                        // 1 sources

                        throw new DownloadInterruptedError((Throwable)e);
                    }
                    this.info.setState(VideoInfo.States.DONE);
                    notify.run();
                    return;
                }
                catch (DownloadRetry e) {
                    this.retry(user, stop, notify, e);
                }
                catch (DownloadMultipartError e) {
                    this.checkFileNotFound(e);
                    this.checkRetry(e);
                    this.retry(user, stop, notify, e);
                }
                catch (DownloadIOCodeError e) {
                    if (this.retry(e)) {
                        this.retry(user, stop, notify, e);
                        continue;
                    }
                    throw e;
                }
                catch (DownloadIOError e) {
                    this.retry(user, stop, notify, e);
                }
            }
        }
        catch (DownloadInterruptedError e) {
            this.info.setState(VideoInfo.States.STOP, e);
            notify.run();
            throw e;
        }
        catch (RuntimeException e) {
            this.info.setState(VideoInfo.States.ERROR, e);
            notify.run();
            throw e;
        }
    }

    public static VGetParser parser(URL web) {
        return VGet.parser(null, web);
    }

    public static VGetParser parser(VGetParser user, URL web) {
        VGetParser ei = user;
        if (ei == null && YouTubeParser.probe(web)) {
            ei = new YouTubeParser();
        }
        if (ei == null && VimeoParser.probe(web)) {
            ei = new VimeoParser();
        }
        if (ei == null) {
            throw new RuntimeException("unsupported web site");
        }
        return ei;
    }
}

