/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.request.model;

import it.auties.whatsapp4j.manager.WhatsappDataManager;
import it.auties.whatsapp4j.response.model.common.Response;
import it.auties.whatsapp4j.response.model.common.ResponseModel;
import it.auties.whatsapp4j.utils.WhatsappUtils;
import it.auties.whatsapp4j.whatsapp.WhatsappConfiguration;
import jakarta.websocket.Session;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Request<B, M extends ResponseModel> {
    protected static final WhatsappDataManager MANAGER = WhatsappDataManager.singletonInstance();
    @NonNull
    protected final String tag;
    @NonNull
    protected final WhatsappConfiguration configuration;
    @NonNull
    protected final CompletableFuture<M> future;
    protected boolean noResponse;

    protected Request(@NonNull String tag, @NonNull WhatsappConfiguration configuration) {
        this(tag, configuration, new CompletableFuture());
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
    }

    protected Request(@NonNull WhatsappConfiguration configuration) {
        this(WhatsappUtils.buildRequestTag(configuration), configuration);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
    }

    @NonNull
    public abstract B buildBody();

    @NonNull
    public abstract CompletableFuture<M> send(@NonNull Session var1);

    public void complete(@NonNull Response<?> response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.future.completeAsync(() -> response.toModel(this.modelClass()));
    }

    @NonNull
    private Class<M> modelClass() throws ClassCastException {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    protected void addRequest() {
        if (this.noResponse()) {
            this.future.complete(null);
            return;
        }
        MANAGER.pendingRequests().add(this);
    }

    public Request(@NonNull String tag, @NonNull WhatsappConfiguration configuration, @NonNull CompletableFuture<M> future) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        this.tag = tag;
        this.configuration = configuration;
        this.future = future;
    }

    @NonNull
    public String tag() {
        return this.tag;
    }

    @NonNull
    public CompletableFuture<M> future() {
        return this.future;
    }

    public boolean noResponse() {
        return this.noResponse;
    }

    public Request<B, M> noResponse(boolean noResponse) {
        this.noResponse = noResponse;
        return this;
    }
}

