/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.request.impl;

import it.auties.whatsapp4j.binary.BinaryArray;
import it.auties.whatsapp4j.manager.WhatsappKeysManager;
import it.auties.whatsapp4j.request.model.JsonRequest;
import it.auties.whatsapp4j.response.model.json.JsonResponseModel;
import it.auties.whatsapp4j.whatsapp.WhatsappConfiguration;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;

public abstract class SolveChallengeRequest<M extends JsonResponseModel>
extends JsonRequest<M> {
    @NonNull
    private final WhatsappKeysManager whatsappKeys;
    @NonNull
    private final BinaryArray challenge;

    public SolveChallengeRequest(@NonNull WhatsappConfiguration configuration, @NonNull WhatsappKeysManager whatsappKeys, @NonNull BinaryArray challenge) {
        super(configuration);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (whatsappKeys == null) {
            throw new NullPointerException("whatsappKeys is marked non-null but is null");
        }
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        this.whatsappKeys = whatsappKeys;
        this.challenge = challenge;
    }

    @Override
    @NonNull
    public List<Object> buildBody() {
        return List.of("admin", "challenge", Base64.getEncoder().encodeToString(this.challenge.data()), Objects.requireNonNull(this.whatsappKeys.serverToken()), this.whatsappKeys.clientId());
    }
}

