/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class Point {
    @JsonProperty(value="4")
    private double y;
    @JsonProperty(value="3")
    private double x;
    @JsonProperty(value="2")
    @Deprecated
    private int yDeprecated;
    @JsonProperty(value="1")
    @Deprecated
    private int xDeprecated;

    public static PointBuilder builder() {
        return new PointBuilder();
    }

    public Point(double y, double x, int yDeprecated, int xDeprecated) {
        this.y = y;
        this.x = x;
        this.yDeprecated = yDeprecated;
        this.xDeprecated = xDeprecated;
    }

    public Point() {
    }

    public double y() {
        return this.y;
    }

    public double x() {
        return this.x;
    }

    @Deprecated
    public int yDeprecated() {
        return this.yDeprecated;
    }

    @Deprecated
    public int xDeprecated() {
        return this.xDeprecated;
    }

    @JsonProperty(value="4")
    public Point y(double y) {
        this.y = y;
        return this;
    }

    @JsonProperty(value="3")
    public Point x(double x) {
        this.x = x;
        return this;
    }

    @Deprecated
    @JsonProperty(value="2")
    public Point yDeprecated(int yDeprecated) {
        this.yDeprecated = yDeprecated;
        return this;
    }

    @Deprecated
    @JsonProperty(value="1")
    public Point xDeprecated(int xDeprecated) {
        this.xDeprecated = xDeprecated;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.y(), other.y()) != 0) {
            return false;
        }
        if (Double.compare(this.x(), other.x()) != 0) {
            return false;
        }
        if (this.yDeprecated() != other.yDeprecated()) {
            return false;
        }
        return this.xDeprecated() == other.xDeprecated();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $y = Double.doubleToLongBits(this.y());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $x = Double.doubleToLongBits(this.x());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        result = result * 59 + this.yDeprecated();
        result = result * 59 + this.xDeprecated();
        return result;
    }

    public String toString() {
        return "Point(y=" + this.y() + ", x=" + this.x() + ", yDeprecated=" + this.yDeprecated() + ", xDeprecated=" + this.xDeprecated() + ")";
    }

    public static class PointBuilder {
        private double y;
        private double x;
        private int yDeprecated;
        private int xDeprecated;

        PointBuilder() {
        }

        @JsonProperty(value="4")
        public PointBuilder y(double y) {
            this.y = y;
            return this;
        }

        @JsonProperty(value="3")
        public PointBuilder x(double x) {
            this.x = x;
            return this;
        }

        @Deprecated
        @JsonProperty(value="2")
        public PointBuilder yDeprecated(int yDeprecated) {
            this.yDeprecated = yDeprecated;
            return this;
        }

        @Deprecated
        @JsonProperty(value="1")
        public PointBuilder xDeprecated(int xDeprecated) {
            this.xDeprecated = xDeprecated;
            return this;
        }

        public Point build() {
            return new Point(this.y, this.x, this.yDeprecated, this.xDeprecated);
        }

        public String toString() {
            return "Point.PointBuilder(y=" + this.y + ", x=" + this.x + ", yDeprecated=" + this.yDeprecated + ", xDeprecated=" + this.xDeprecated + ")";
        }
    }
}

