/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.message.standard;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.media.MediaUpload;
import it.auties.whatsapp4j.protobuf.info.ContextInfo;
import it.auties.whatsapp4j.protobuf.message.model.ContextualMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessageType;
import it.auties.whatsapp4j.protobuf.model.InteractiveAnnotation;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class ImageMessage
extends MediaMessage {
    @JsonProperty(value="24")
    private byte[] midQualityFileEncSha256;
    @JsonProperty(value="23")
    private byte[] midQualityFileSha256;
    @JsonProperty(value="22")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<Integer> scanLengths;
    @JsonProperty(value="21")
    private byte[] scansSidecar;
    @JsonProperty(value="19")
    private int firstScanLength;
    @JsonProperty(value="18")
    private byte[] firstScanSidecar;
    @JsonProperty(value="20")
    private int experimentGroupId;
    @JsonProperty(value="16")
    private byte[] jpegThumbnail;
    @JsonProperty(value="12")
    private long mediaKeyTimestamp;
    @JsonProperty(value="11")
    private String directPath;
    @JsonProperty(value="10")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<InteractiveAnnotation> interactiveAnnotations;
    @JsonProperty(value="9")
    private byte[] fileEncSha256;
    @JsonProperty(value="8")
    private byte[] mediaKey;
    @JsonProperty(value="7")
    private int width;
    @JsonProperty(value="6")
    private int height;
    @JsonProperty(value="5")
    private long fileLength;
    @JsonProperty(value="4")
    private byte[] fileSha256;
    @JsonProperty(value="3")
    private String caption;
    @JsonProperty(value="2")
    private String mimetype;
    @JsonProperty(value="1")
    private String url;

    private static ImageMessage simpleBuilder(byte @NonNull [] media, String mimeType, String caption, int width, int height, ContextInfo contextInfo) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        MediaUpload upload = CypherUtils.mediaEncrypt(media, MediaMessageType.IMAGE);
        return ((ImageMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)ImageMessage.newRawImageMessage().fileSha256(upload.fileSha256())).fileEncSha256(upload.fileEncSha256())).mediaKey(upload.mediaKey().data())).mediaKeyTimestamp(ZonedDateTime.now().toEpochSecond())).url(upload.url())).directPath(upload.directPath())).fileLength(media.length)).mimetype(Optional.ofNullable(mimeType).orElse(MediaMessageType.IMAGE.defaultMimeType()))).caption(caption)).width(width)).height(height)).contextInfo(contextInfo)).create();
    }

    @Override
    @NonNull
    public MediaMessageType type() {
        return MediaMessageType.IMAGE;
    }

    protected ImageMessage(ImageMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.midQualityFileEncSha256 = b.midQualityFileEncSha256;
        this.midQualityFileSha256 = b.midQualityFileSha256;
        this.scanLengths = b.scanLengths;
        this.scansSidecar = b.scansSidecar;
        this.firstScanLength = b.firstScanLength;
        this.firstScanSidecar = b.firstScanSidecar;
        this.experimentGroupId = b.experimentGroupId;
        this.jpegThumbnail = b.jpegThumbnail;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.directPath = b.directPath;
        this.interactiveAnnotations = b.interactiveAnnotations;
        this.fileEncSha256 = b.fileEncSha256;
        this.mediaKey = b.mediaKey;
        this.width = b.width;
        this.height = b.height;
        this.fileLength = b.fileLength;
        this.fileSha256 = b.fileSha256;
        this.caption = b.caption;
        this.mimetype = b.mimetype;
        this.url = b.url;
    }

    public static ImageMessageBuilder<?, ?> newRawImageMessage() {
        return new ImageMessageBuilderImpl();
    }

    public static NewImageMessageBuilder newImageMessage() {
        return new NewImageMessageBuilder();
    }

    public ImageMessage(byte[] midQualityFileEncSha256, byte[] midQualityFileSha256, List<Integer> scanLengths, byte[] scansSidecar, int firstScanLength, byte[] firstScanSidecar, int experimentGroupId, byte[] jpegThumbnail, long mediaKeyTimestamp, String directPath, List<InteractiveAnnotation> interactiveAnnotations, byte[] fileEncSha256, byte[] mediaKey, int width, int height, long fileLength, byte[] fileSha256, String caption, String mimetype, String url) {
        this.midQualityFileEncSha256 = midQualityFileEncSha256;
        this.midQualityFileSha256 = midQualityFileSha256;
        this.scanLengths = scanLengths;
        this.scansSidecar = scansSidecar;
        this.firstScanLength = firstScanLength;
        this.firstScanSidecar = firstScanSidecar;
        this.experimentGroupId = experimentGroupId;
        this.jpegThumbnail = jpegThumbnail;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.directPath = directPath;
        this.interactiveAnnotations = interactiveAnnotations;
        this.fileEncSha256 = fileEncSha256;
        this.mediaKey = mediaKey;
        this.width = width;
        this.height = height;
        this.fileLength = fileLength;
        this.fileSha256 = fileSha256;
        this.caption = caption;
        this.mimetype = mimetype;
        this.url = url;
    }

    public ImageMessage() {
    }

    public byte[] midQualityFileEncSha256() {
        return this.midQualityFileEncSha256;
    }

    public byte[] midQualityFileSha256() {
        return this.midQualityFileSha256;
    }

    public List<Integer> scanLengths() {
        return this.scanLengths;
    }

    public byte[] scansSidecar() {
        return this.scansSidecar;
    }

    public int firstScanLength() {
        return this.firstScanLength;
    }

    public byte[] firstScanSidecar() {
        return this.firstScanSidecar;
    }

    public int experimentGroupId() {
        return this.experimentGroupId;
    }

    public byte[] jpegThumbnail() {
        return this.jpegThumbnail;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    @Override
    public String directPath() {
        return this.directPath;
    }

    public List<InteractiveAnnotation> interactiveAnnotations() {
        return this.interactiveAnnotations;
    }

    @Override
    public byte[] fileEncSha256() {
        return this.fileEncSha256;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    @Override
    public long fileLength() {
        return this.fileLength;
    }

    @Override
    public byte[] fileSha256() {
        return this.fileSha256;
    }

    public String caption() {
        return this.caption;
    }

    public String mimetype() {
        return this.mimetype;
    }

    @Override
    public String url() {
        return this.url;
    }

    @JsonProperty(value="24")
    public ImageMessage midQualityFileEncSha256(byte[] midQualityFileEncSha256) {
        this.midQualityFileEncSha256 = midQualityFileEncSha256;
        return this;
    }

    @JsonProperty(value="23")
    public ImageMessage midQualityFileSha256(byte[] midQualityFileSha256) {
        this.midQualityFileSha256 = midQualityFileSha256;
        return this;
    }

    @JsonProperty(value="22")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public ImageMessage scanLengths(List<Integer> scanLengths) {
        this.scanLengths = scanLengths;
        return this;
    }

    @JsonProperty(value="21")
    public ImageMessage scansSidecar(byte[] scansSidecar) {
        this.scansSidecar = scansSidecar;
        return this;
    }

    @JsonProperty(value="19")
    public ImageMessage firstScanLength(int firstScanLength) {
        this.firstScanLength = firstScanLength;
        return this;
    }

    @JsonProperty(value="18")
    public ImageMessage firstScanSidecar(byte[] firstScanSidecar) {
        this.firstScanSidecar = firstScanSidecar;
        return this;
    }

    @JsonProperty(value="20")
    public ImageMessage experimentGroupId(int experimentGroupId) {
        this.experimentGroupId = experimentGroupId;
        return this;
    }

    @JsonProperty(value="16")
    public ImageMessage jpegThumbnail(byte[] jpegThumbnail) {
        this.jpegThumbnail = jpegThumbnail;
        return this;
    }

    @JsonProperty(value="12")
    public ImageMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    @JsonProperty(value="11")
    public ImageMessage directPath(String directPath) {
        this.directPath = directPath;
        return this;
    }

    @JsonProperty(value="10")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public ImageMessage interactiveAnnotations(List<InteractiveAnnotation> interactiveAnnotations) {
        this.interactiveAnnotations = interactiveAnnotations;
        return this;
    }

    @JsonProperty(value="9")
    public ImageMessage fileEncSha256(byte[] fileEncSha256) {
        this.fileEncSha256 = fileEncSha256;
        return this;
    }

    @JsonProperty(value="8")
    public ImageMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @JsonProperty(value="7")
    public ImageMessage width(int width) {
        this.width = width;
        return this;
    }

    @JsonProperty(value="6")
    public ImageMessage height(int height) {
        this.height = height;
        return this;
    }

    @JsonProperty(value="5")
    public ImageMessage fileLength(long fileLength) {
        this.fileLength = fileLength;
        return this;
    }

    @JsonProperty(value="4")
    public ImageMessage fileSha256(byte[] fileSha256) {
        this.fileSha256 = fileSha256;
        return this;
    }

    @JsonProperty(value="3")
    public ImageMessage caption(String caption) {
        this.caption = caption;
        return this;
    }

    @JsonProperty(value="2")
    public ImageMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    @JsonProperty(value="1")
    public ImageMessage url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return "ImageMessage(midQualityFileEncSha256=" + Arrays.toString(this.midQualityFileEncSha256()) + ", midQualityFileSha256=" + Arrays.toString(this.midQualityFileSha256()) + ", scanLengths=" + this.scanLengths() + ", scansSidecar=" + Arrays.toString(this.scansSidecar()) + ", firstScanLength=" + this.firstScanLength() + ", firstScanSidecar=" + Arrays.toString(this.firstScanSidecar()) + ", experimentGroupId=" + this.experimentGroupId() + ", jpegThumbnail=" + Arrays.toString(this.jpegThumbnail()) + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", directPath=" + this.directPath() + ", interactiveAnnotations=" + this.interactiveAnnotations() + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256()) + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", width=" + this.width() + ", height=" + this.height() + ", fileLength=" + this.fileLength() + ", fileSha256=" + Arrays.toString(this.fileSha256()) + ", caption=" + this.caption() + ", mimetype=" + this.mimetype() + ", url=" + this.url() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageMessage)) {
            return false;
        }
        ImageMessage other = (ImageMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.firstScanLength() != other.firstScanLength()) {
            return false;
        }
        if (this.experimentGroupId() != other.experimentGroupId()) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        if (this.width() != other.width()) {
            return false;
        }
        if (this.height() != other.height()) {
            return false;
        }
        if (this.fileLength() != other.fileLength()) {
            return false;
        }
        if (!Arrays.equals(this.midQualityFileEncSha256(), other.midQualityFileEncSha256())) {
            return false;
        }
        if (!Arrays.equals(this.midQualityFileSha256(), other.midQualityFileSha256())) {
            return false;
        }
        List<Integer> this$scanLengths = this.scanLengths();
        List<Integer> other$scanLengths = other.scanLengths();
        if (this$scanLengths == null ? other$scanLengths != null : !((Object)this$scanLengths).equals(other$scanLengths)) {
            return false;
        }
        if (!Arrays.equals(this.scansSidecar(), other.scansSidecar())) {
            return false;
        }
        if (!Arrays.equals(this.firstScanSidecar(), other.firstScanSidecar())) {
            return false;
        }
        if (!Arrays.equals(this.jpegThumbnail(), other.jpegThumbnail())) {
            return false;
        }
        String this$directPath = this.directPath();
        String other$directPath = other.directPath();
        if (this$directPath == null ? other$directPath != null : !this$directPath.equals(other$directPath)) {
            return false;
        }
        List<InteractiveAnnotation> this$interactiveAnnotations = this.interactiveAnnotations();
        List<InteractiveAnnotation> other$interactiveAnnotations = other.interactiveAnnotations();
        if (this$interactiveAnnotations == null ? other$interactiveAnnotations != null : !((Object)this$interactiveAnnotations).equals(other$interactiveAnnotations)) {
            return false;
        }
        if (!Arrays.equals(this.fileEncSha256(), other.fileEncSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        if (!Arrays.equals(this.fileSha256(), other.fileSha256())) {
            return false;
        }
        String this$caption = this.caption();
        String other$caption = other.caption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImageMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.firstScanLength();
        result = result * 59 + this.experimentGroupId();
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        result = result * 59 + this.width();
        result = result * 59 + this.height();
        long $fileLength = this.fileLength();
        result = result * 59 + (int)($fileLength >>> 32 ^ $fileLength);
        result = result * 59 + Arrays.hashCode(this.midQualityFileEncSha256());
        result = result * 59 + Arrays.hashCode(this.midQualityFileSha256());
        List<Integer> $scanLengths = this.scanLengths();
        result = result * 59 + ($scanLengths == null ? 43 : ((Object)$scanLengths).hashCode());
        result = result * 59 + Arrays.hashCode(this.scansSidecar());
        result = result * 59 + Arrays.hashCode(this.firstScanSidecar());
        result = result * 59 + Arrays.hashCode(this.jpegThumbnail());
        String $directPath = this.directPath();
        result = result * 59 + ($directPath == null ? 43 : $directPath.hashCode());
        List<InteractiveAnnotation> $interactiveAnnotations = this.interactiveAnnotations();
        result = result * 59 + ($interactiveAnnotations == null ? 43 : ((Object)$interactiveAnnotations).hashCode());
        result = result * 59 + Arrays.hashCode(this.fileEncSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        result = result * 59 + Arrays.hashCode(this.fileSha256());
        String $caption = this.caption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public static abstract class ImageMessageBuilder<C extends ImageMessage, B extends ImageMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private byte[] midQualityFileEncSha256;
        private byte[] midQualityFileSha256;
        private List<Integer> scanLengths;
        private byte[] scansSidecar;
        private int firstScanLength;
        private byte[] firstScanSidecar;
        private int experimentGroupId;
        private byte[] jpegThumbnail;
        private long mediaKeyTimestamp;
        private String directPath;
        private List<InteractiveAnnotation> interactiveAnnotations;
        private byte[] fileEncSha256;
        private byte[] mediaKey;
        private int width;
        private int height;
        private long fileLength;
        private byte[] fileSha256;
        private String caption;
        private String mimetype;
        private String url;

        @Override
        protected abstract B self();

        @Override
        public abstract C create();

        @JsonProperty(value="24")
        public B midQualityFileEncSha256(byte[] midQualityFileEncSha256) {
            this.midQualityFileEncSha256 = midQualityFileEncSha256;
            return (B)this.self();
        }

        @JsonProperty(value="23")
        public B midQualityFileSha256(byte[] midQualityFileSha256) {
            this.midQualityFileSha256 = midQualityFileSha256;
            return (B)this.self();
        }

        @JsonProperty(value="22")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public B scanLengths(List<Integer> scanLengths) {
            this.scanLengths = scanLengths;
            return (B)this.self();
        }

        @JsonProperty(value="21")
        public B scansSidecar(byte[] scansSidecar) {
            this.scansSidecar = scansSidecar;
            return (B)this.self();
        }

        @JsonProperty(value="19")
        public B firstScanLength(int firstScanLength) {
            this.firstScanLength = firstScanLength;
            return (B)this.self();
        }

        @JsonProperty(value="18")
        public B firstScanSidecar(byte[] firstScanSidecar) {
            this.firstScanSidecar = firstScanSidecar;
            return (B)this.self();
        }

        @JsonProperty(value="20")
        public B experimentGroupId(int experimentGroupId) {
            this.experimentGroupId = experimentGroupId;
            return (B)this.self();
        }

        @JsonProperty(value="16")
        public B jpegThumbnail(byte[] jpegThumbnail) {
            this.jpegThumbnail = jpegThumbnail;
            return (B)this.self();
        }

        @JsonProperty(value="12")
        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        @JsonProperty(value="11")
        public B directPath(String directPath) {
            this.directPath = directPath;
            return (B)this.self();
        }

        @JsonProperty(value="10")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public B interactiveAnnotations(List<InteractiveAnnotation> interactiveAnnotations) {
            this.interactiveAnnotations = interactiveAnnotations;
            return (B)this.self();
        }

        @JsonProperty(value="9")
        public B fileEncSha256(byte[] fileEncSha256) {
            this.fileEncSha256 = fileEncSha256;
            return (B)this.self();
        }

        @JsonProperty(value="8")
        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        @JsonProperty(value="7")
        public B width(int width) {
            this.width = width;
            return (B)this.self();
        }

        @JsonProperty(value="6")
        public B height(int height) {
            this.height = height;
            return (B)this.self();
        }

        @JsonProperty(value="5")
        public B fileLength(long fileLength) {
            this.fileLength = fileLength;
            return (B)this.self();
        }

        @JsonProperty(value="4")
        public B fileSha256(byte[] fileSha256) {
            this.fileSha256 = fileSha256;
            return (B)this.self();
        }

        @JsonProperty(value="3")
        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        @JsonProperty(value="2")
        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        @JsonProperty(value="1")
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ImageMessage.ImageMessageBuilder(super=" + super.toString() + ", midQualityFileEncSha256=" + Arrays.toString(this.midQualityFileEncSha256) + ", midQualityFileSha256=" + Arrays.toString(this.midQualityFileSha256) + ", scanLengths=" + this.scanLengths + ", scansSidecar=" + Arrays.toString(this.scansSidecar) + ", firstScanLength=" + this.firstScanLength + ", firstScanSidecar=" + Arrays.toString(this.firstScanSidecar) + ", experimentGroupId=" + this.experimentGroupId + ", jpegThumbnail=" + Arrays.toString(this.jpegThumbnail) + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", directPath=" + this.directPath + ", interactiveAnnotations=" + this.interactiveAnnotations + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256) + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", width=" + this.width + ", height=" + this.height + ", fileLength=" + this.fileLength + ", fileSha256=" + Arrays.toString(this.fileSha256) + ", caption=" + this.caption + ", mimetype=" + this.mimetype + ", url=" + this.url + ")";
        }
    }

    private static final class ImageMessageBuilderImpl
    extends ImageMessageBuilder<ImageMessage, ImageMessageBuilderImpl> {
        private ImageMessageBuilderImpl() {
        }

        @Override
        protected ImageMessageBuilderImpl self() {
            return this;
        }

        @Override
        public ImageMessage create() {
            return new ImageMessage(this);
        }
    }

    public static class NewImageMessageBuilder {
        private byte @NonNull [] media;
        private String mimeType;
        private String caption;
        private int width;
        private int height;
        private ContextInfo contextInfo;

        NewImageMessageBuilder() {
        }

        public NewImageMessageBuilder media(byte @NonNull [] media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public NewImageMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public NewImageMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public NewImageMessageBuilder width(int width) {
            this.width = width;
            return this;
        }

        public NewImageMessageBuilder height(int height) {
            this.height = height;
            return this;
        }

        public NewImageMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public ImageMessage create() {
            return ImageMessage.simpleBuilder(this.media, this.mimeType, this.caption, this.width, this.height, this.contextInfo);
        }

        public String toString() {
            return "ImageMessage.NewImageMessageBuilder(media=" + this.media + ", mimeType=" + this.mimeType + ", caption=" + this.caption + ", width=" + this.width + ", height=" + this.height + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

