/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.message.model;

import it.auties.whatsapp4j.protobuf.message.model.ContextualMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessageType;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import java.util.Arrays;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MediaMessage
extends ContextualMessage {
    private byte[] decodedMedia;

    public byte @NonNull [] decodedMedia() {
        if (this.decodedMedia == null) {
            this.decodedMedia = CypherUtils.mediaDecrypt(this);
        }
        return this.decodedMedia;
    }

    public byte @NonNull [] refreshMedia() {
        this.decodedMedia = CypherUtils.mediaDecrypt(this);
        return this.decodedMedia;
    }

    @NonNull
    public abstract String url();

    @NonNull
    public abstract String directPath();

    @NonNull
    public abstract MediaMessageType type();

    public abstract byte @NonNull [] mediaKey();

    public abstract long mediaKeyTimestamp();

    public abstract byte @NonNull [] fileSha256();

    public abstract byte @NonNull [] fileEncSha256();

    public abstract long fileLength();

    protected MediaMessage(MediaMessageBuilder<?, ?> b) {
        super(b);
        this.decodedMedia = b.decodedMedia;
    }

    public MediaMessage(byte[] decodedMedia) {
        this.decodedMedia = decodedMedia;
    }

    public MediaMessage() {
    }

    public static abstract class MediaMessageBuilder<C extends MediaMessage, B extends MediaMessageBuilder<C, B>>
    extends ContextualMessage.ContextualMessageBuilder<C, B> {
        private byte[] decodedMedia;

        @Override
        protected abstract B self();

        @Override
        public abstract C create();

        public B decodedMedia(byte[] decodedMedia) {
            this.decodedMedia = decodedMedia;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MediaMessage.MediaMessageBuilder(super=" + super.toString() + ", decodedMedia=" + Arrays.toString(this.decodedMedia) + ")";
        }
    }
}

