/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.chat;

import it.auties.whatsapp4j.protobuf.chat.ChatMuteType;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.NonNull;

public record ChatMute(long time) {
    public static final ChatMute UNKNOWN = new ChatMute(Integer.MIN_VALUE);

    public boolean isMuted() {
        return this.type() != ChatMuteType.NOT_MUTED && this.type() != ChatMuteType.UNKNOWN;
    }

    @NonNull
    public ChatMuteType type() {
        if (this == UNKNOWN) {
            return ChatMuteType.UNKNOWN;
        }
        if (this.time == -1L) {
            return ChatMuteType.MUTED_INDEFINITELY;
        }
        if (this.time == 0L) {
            return ChatMuteType.NOT_MUTED;
        }
        return ChatMuteType.MUTED_FOR_TIMEFRAME;
    }

    @NonNull
    public Optional<ZonedDateTime> muteEndDate() {
        return this.isMuted() ? Optional.of(ZonedDateTime.ofInstant(Instant.ofEpochSecond(this.time), ZoneId.systemDefault())) : Optional.empty();
    }
}

