/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.util;

import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;

public final class IllegalReflection {
    private static final Unsafe unsafe = IllegalReflection.openUnsafe();
    private static final long offset = IllegalReflection.findOffset();

    private static long findOffset() {
        try {
            Field offsetField = AccessibleObject.class.getDeclaredField("override");
            return unsafe.objectFieldOffset(offsetField);
        }
        catch (Throwable throwable) {
            return IllegalReflection.findOffsetFallback();
        }
    }

    private static long findOffsetFallback() {
        try {
            return unsafe.objectFieldOffset(AccessibleObjectPlaceholder.class.getDeclaredField("override"));
        }
        catch (Throwable innerThrowable) {
            return -1L;
        }
    }

    private static Unsafe openUnsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (NoSuchFieldException exception) {
            throw new NoSuchElementException("Cannot find unsafe field in wrapper class");
        }
        catch (IllegalAccessException exception) {
            throw new UnsupportedOperationException("Access to the unsafe wrapper has been blocked: the day has come. In this future has the OpenJDK team created a publicly available compiler api that can do something? Probably not", exception);
        }
    }

    public static <T extends AccessibleObject> T opened(T object) {
        if (offset != -1L) {
            unsafe.putBoolean(object, offset, true);
            return object;
        }
        object.setAccessible(true);
        return object;
    }

    private IllegalReflection() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class AccessibleObjectPlaceholder {
        boolean override;
        Object accessCheckCache;

        private AccessibleObjectPlaceholder() {
        }
    }

    public static class ModulePlaceholder {
        boolean first;
        static final Object staticObj = OutputStream.class;
        volatile Object second;
        private static volatile boolean staticSecond;
        private static volatile boolean staticThird;
    }
}

