/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.ArrayOps$;
import com.github.arturopala.bufferandslice.Buffer;
import com.github.arturopala.bufferandslice.Buffer$;
import com.github.arturopala.bufferandslice.DeferredArrayBuffer;
import com.github.arturopala.bufferandslice.LazyMapArraySlice$;
import com.github.arturopala.bufferandslice.Slice;
import com.github.arturopala.bufferandslice.Slice$;
import scala.Function1;
import scala.runtime.ScalaRunTime$;

public abstract class LazyMapArraySlice<T>
implements Slice<T> {
    private final int fromIndex;
    private final int toIndex;
    private final boolean detached;
    private final int length;

    public static <T, K> LazyMapArraySlice<T> lazilyMapped(int n, int n2, Object object, Function1<K, T> function1, boolean bl) {
        return LazyMapArraySlice$.MODULE$.lazilyMapped(n, n2, object, function1, bl);
    }

    public LazyMapArraySlice(int fromIndex, int toIndex, boolean detached) {
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.detached = detached;
        this.length = toIndex - fromIndex;
    }

    public abstract Object array();

    public abstract Function1<Object, T> mapF();

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final T read(int index) {
        return (T)this.mapF().apply(ScalaRunTime$.MODULE$.array_apply(this.array(), this.fromIndex + index));
    }

    @Override
    public final <T1> Slice<T1> update(int index, T1 value) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException(new StringBuilder(58).append("Expected an `update` index in the interval [0,").append(this.length()).append("), but was ").append(index).append(".").toString());
        }
        return Slice$.MODULE$.of(this.toBuffer().update(index, value).asArray());
    }

    @Override
    public final <K> LazyMapArraySlice<K> map(Function1<T, K> f) {
        return LazyMapArraySlice$.MODULE$.lazilyMapped(this.fromIndex, this.toIndex, this.array(), this.mapF().andThen(f), this.detached);
    }

    @Override
    public final LazyMapArraySlice slice(int from, int to) {
        int t = LazyMapArraySlice.fit$1(to, this.length());
        int f = LazyMapArraySlice.fit$1(from, t);
        return f == 0 && t == this.length() ? this : LazyMapArraySlice$.MODULE$.lazilyMapped(this.fromIndex + f, this.fromIndex + t, this.array(), this.mapF(), this.detached);
    }

    @Override
    public final Object asArray() {
        return ArrayOps$.MODULE$.copyMapOf(this.fromIndex, this.toIndex, this.array(), this.mapF());
    }

    @Override
    public final LazyMapArraySlice detach() {
        LazyMapArraySlice<T> lazyMapArraySlice;
        if (this.detached) {
            lazyMapArraySlice = this;
        } else {
            Object newArray = ArrayOps$.MODULE$.copyOf(this.array(), this.length());
            System.arraycopy(this.array(), this.fromIndex, newArray, 0, this.length());
            lazyMapArraySlice = LazyMapArraySlice$.MODULE$.lazilyMapped(0, this.length(), newArray, this.mapF(), true);
        }
        return lazyMapArraySlice;
    }

    @Override
    public final <T1> Buffer<T1> toBuffer() {
        return new DeferredArrayBuffer(0).appendSlice((Slice)this);
    }

    @Override
    public final Buffer<T> asBuffer() {
        return Buffer$.MODULE$.apply(this.asArray());
    }

    private static final int fit$1(int value, int upper) {
        return Math.min(Math.max(0, value), upper);
    }
}

