/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.Slice;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface Buffer<T>
extends Function1<Object, T> {
    public static void $init$(Buffer $this) {
        $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(-1);
    }

    public int com$github$arturopala$bufferandslice$Buffer$$topIndex();

    public void com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(int var1);

    public T read(int var1);

    public void write(int var1, T var2);

    public T apply(int var1);

    public Buffer update(int var1, T var2);

    public void ensureIndex(int var1);

    public Buffer copy();

    public Buffer emptyCopy();

    public <T1> Object toArray(ClassTag<T1> var1);

    public Object asArray();

    public Slice<T> asSlice();

    public Slice<T> slice(int var1, int var2);

    public Buffer optimize();

    public static int length$(Buffer $this) {
        return $this.length();
    }

    default public int length() {
        return this.com$github$arturopala$bufferandslice$Buffer$$topIndex() + 1;
    }

    public static boolean isEmpty$(Buffer $this) {
        return $this.isEmpty();
    }

    default public boolean isEmpty() {
        return this.length() == 0;
    }

    public static boolean nonEmpty$(Buffer $this) {
        return $this.nonEmpty();
    }

    default public boolean nonEmpty() {
        return this.length() > 0;
    }

    public static int top$(Buffer $this) {
        return $this.top();
    }

    default public int top() {
        return this.com$github$arturopala$bufferandslice$Buffer$$topIndex();
    }

    public static Object head$(Buffer $this) {
        return $this.head();
    }

    default public T head() {
        return this.apply(this.com$github$arturopala$bufferandslice$Buffer$$topIndex());
    }

    public static Option headOption$(Buffer $this) {
        return $this.headOption();
    }

    default public Option<T> headOption() {
        return this.com$github$arturopala$bufferandslice$Buffer$$topIndex() < 0 ? None$.MODULE$ : Some$.MODULE$.apply(this.read(this.com$github$arturopala$bufferandslice$Buffer$$topIndex()));
    }

    public static Object last$(Buffer $this) {
        return $this.last();
    }

    default public T last() {
        return this.apply(0);
    }

    public static Option lastOption$(Buffer $this) {
        return $this.lastOption();
    }

    default public Option<T> lastOption() {
        return this.com$github$arturopala$bufferandslice$Buffer$$topIndex() < 0 ? None$.MODULE$ : Some$.MODULE$.apply(this.read(0));
    }

    public static Buffer tail$(Buffer $this) {
        return $this.tail();
    }

    default public Buffer tail() {
        return this.rewind(1);
    }

    public static Buffer init$(Buffer $this) {
        return $this.init();
    }

    default public Buffer init() {
        return this.shiftLeft(1, 1);
    }

    public static Option get$(Buffer $this, int index) {
        return $this.get(index);
    }

    default public Option<T> get(int index) {
        return index >= 0 && index <= this.com$github$arturopala$bufferandslice$Buffer$$topIndex() ? Some$.MODULE$.apply(this.read(index)) : None$.MODULE$;
    }

    public static Buffer modify$(Buffer $this, int index, Function1 map) {
        return $this.modify(index, map);
    }

    default public Buffer modify(int index, Function1<T, T> map) {
        if (index >= 0 && index < this.length()) {
            this.write(index, map.apply(this.read(index)));
            this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max(index, this.com$github$arturopala$bufferandslice$Buffer$$topIndex()));
        }
        return this;
    }

    public static Buffer mapInPlace$(Buffer $this, Function1 f) {
        return $this.mapInPlace(f);
    }

    default public Buffer mapInPlace(Function1<T, T> f) {
        return this.modifyAll(f);
    }

    public static Iterable map$(Buffer $this, Function1 f) {
        return $this.map(f);
    }

    default public <K> Iterable<K> map(Function1<T, K> f) {
        return new Iterable<K>(f, this){
            private final Function1 f$1;
            private final Buffer $outer;
            {
                this.f$1 = f$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
            }

            public final Iterator iterator() {
                return this.$outer.iterator().map(this.f$1);
            }
        };
    }

    public static Buffer modifyAll$(Buffer $this, Function1 map) {
        return $this.modifyAll(map);
    }

    default public Buffer modifyAll(Function1<T, T> map) {
        for (int i = 0; i < this.length(); ++i) {
            this.write(i, map.apply(this.read(i)));
        }
        return this;
    }

    public static Buffer modifyAllWhen$(Buffer $this, Function1 map, Function1 pred) {
        return $this.modifyAllWhen(map, pred);
    }

    default public Buffer modifyAllWhen(Function1<T, T> map, Function1<T, Object> pred) {
        for (int i = 0; i < this.length(); ++i) {
            T v = this.read(i);
            if (!BoxesRunTime.unboxToBoolean((Object)pred.apply(v))) continue;
            this.write(i, map.apply(v));
        }
        return this;
    }

    public static Buffer modifyRange$(Buffer $this, int fromIndex, int toIndex, Function1 map) {
        return $this.modifyRange(fromIndex, toIndex, map);
    }

    default public Buffer modifyRange(int fromIndex, int toIndex, Function1<T, T> map) {
        if (toIndex > 0 && fromIndex < this.length()) {
            int i;
            int limit = Math.min(this.length(), toIndex);
            for (i = Math.max(0, fromIndex); i < limit; ++i) {
                this.write(i, map.apply(this.read(i)));
            }
            this.touch(i - 1);
        }
        return this;
    }

    public static Buffer modifyRangeWhen$(Buffer $this, int fromIndex, int toIndex, Function1 map, Function1 pred) {
        return $this.modifyRangeWhen(fromIndex, toIndex, map, pred);
    }

    default public Buffer modifyRangeWhen(int fromIndex, int toIndex, Function1<T, T> map, Function1<T, Object> pred) {
        if (toIndex > 0 && fromIndex < this.length()) {
            int i;
            int limit = Math.min(this.length(), toIndex);
            for (i = Math.max(0, fromIndex); i < limit; ++i) {
                T v = this.read(i);
                if (!BoxesRunTime.unboxToBoolean((Object)pred.apply(v))) continue;
                this.write(i, map.apply(v));
            }
            this.touch(i - 1);
        }
        return this;
    }

    public static Buffer set$(Buffer $this, int index) {
        return $this.set(index);
    }

    default public Buffer set(int index) {
        this.ensureIndex(index);
        this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max(-1, index));
        return this;
    }

    public static Buffer touch$(Buffer $this, int index) {
        return $this.touch(index);
    }

    default public Buffer touch(int index) {
        this.ensureIndex(index);
        this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max(-1, Math.max(index, this.com$github$arturopala$bufferandslice$Buffer$$topIndex())));
        return this;
    }

    public static Buffer trim$(Buffer $this, int size) {
        return $this.trim(size);
    }

    default public Buffer trim(int size) {
        if (size >= 0 && size < this.length()) {
            this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(size - 1);
        }
        return this;
    }

    public static Buffer rewind$(Buffer $this, int distance) {
        return $this.rewind(distance);
    }

    default public Buffer rewind(int distance) {
        this.ensureIndex(Math.max(-1, this.com$github$arturopala$bufferandslice$Buffer$$topIndex() - distance));
        this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max(-1, this.com$github$arturopala$bufferandslice$Buffer$$topIndex() - distance));
        return this;
    }

    public static Buffer forward$(Buffer $this, int distance) {
        return $this.forward(distance);
    }

    default public Buffer forward(int distance) {
        this.ensureIndex(this.com$github$arturopala$bufferandslice$Buffer$$topIndex() + distance);
        this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(this.com$github$arturopala$bufferandslice$Buffer$$topIndex() < 0 ? distance : this.com$github$arturopala$bufferandslice$Buffer$$topIndex() + distance);
        return this;
    }

    public static int reset$(Buffer $this) {
        return $this.reset();
    }

    /*
     * WARNING - void declaration
     */
    default public int reset() {
        void var1_1;
        int i = this.com$github$arturopala$bufferandslice$Buffer$$topIndex();
        this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(-1);
        return (int)var1_1;
    }

    public static Buffer append$(Buffer $this, Object value) {
        return $this.append(value);
    }

    default public Buffer append(T value) {
        this.update(this.length(), value);
        return this;
    }

    public static Buffer appendArray$(Buffer $this, Object values) {
        return $this.appendArray(values);
    }

    default public Buffer appendArray(Object values) {
        return this.insertArray(this.length(), 0, ScalaRunTime$.MODULE$.array_length(values), values);
    }

    public static Buffer appendSlice$(Buffer $this, Slice slice) {
        return $this.appendSlice(slice);
    }

    default public Buffer appendSlice(Slice<T> slice) {
        return this.insertSlice(this.length(), slice);
    }

    public static Buffer appendSequence$(Buffer $this, IndexedSeq values) {
        return $this.appendSequence(values);
    }

    default public Buffer appendSequence(IndexedSeq<T> values) {
        return this.insertValues(this.length(), 0, values.length(), (Function1<Object, T>)values);
    }

    public static Buffer appendFromIterator$(Buffer $this, Iterator iterator) {
        return $this.appendFromIterator(iterator);
    }

    default public Buffer appendFromIterator(Iterator<T> iterator) {
        int d = 1;
        while (iterator.hasNext()) {
            this.insertFromIterator(this.length(), d, iterator);
            d = Math.min(d * 2, 1024);
        }
        return this;
    }

    public static Buffer appendFromIterator$(Buffer $this, int numberOfValues, Iterator iterator) {
        return $this.appendFromIterator(numberOfValues, iterator);
    }

    default public Buffer appendFromIterator(int numberOfValues, Iterator<T> iterator) {
        return this.insertFromIterator(this.length(), numberOfValues, iterator);
    }

    public static Buffer appendIterable$(Buffer $this, Iterable iterable) {
        return $this.appendIterable(iterable);
    }

    default public Buffer appendIterable(Iterable<T> iterable) {
        return this.appendFromIterator(iterable.size(), iterable.iterator());
    }

    public static Buffer insert$(Buffer $this, int index, Object value) {
        return $this.insert(index, value);
    }

    default public Buffer insert(int index, T value) {
        if (index >= 0) {
            this.shiftRight(index, 1);
            this.write(index, value);
            this.touch(index);
        }
        return this;
    }

    public Buffer insertArray(int var1, int var2, int var3, Object var4);

    public Buffer insertSlice(int var1, Slice<T> var2);

    public static Buffer insertValues$(Buffer $this, int index, int sourceIndex, int numberOfValues, Function1 source) {
        return $this.insertValues(index, sourceIndex, numberOfValues, source);
    }

    default public Buffer insertValues(int index, int sourceIndex, int numberOfValues, Function1<Object, T> source) {
        if (index >= 0 && sourceIndex >= 0 && numberOfValues > 0) {
            this.shiftRight(index, numberOfValues);
            for (int i = 0; i < numberOfValues; ++i) {
                this.write(index + i, source.apply((Object)BoxesRunTime.boxToInteger((int)(sourceIndex + i))));
            }
            this.touch(index + numberOfValues - 1);
        }
        return this;
    }

    public static Buffer insertFromIterator$(Buffer $this, int index, Iterator iterator) {
        return $this.insertFromIterator(index, iterator);
    }

    default public Buffer insertFromIterator(int index, Iterator<T> iterator) {
        if (index >= 0) {
            int i = index;
            int d = 1;
            int l = Math.max(this.length(), index);
            while (iterator.hasNext()) {
                this.insertFromIterator(i, d, iterator);
                i += this.length() - l;
                l = this.length();
                d = Math.min(d * 2, 1024);
            }
        }
        return this;
    }

    public static Buffer insertFromIteratorReverse$(Buffer $this, int index, Iterator iterator) {
        return $this.insertFromIteratorReverse(index, iterator);
    }

    default public Buffer insertFromIteratorReverse(int index, Iterator<T> iterator) {
        if (index >= 0) {
            int d = 1;
            while (iterator.hasNext()) {
                this.insertFromIteratorReverse(index, d, iterator);
                d = Math.min(d * 2, 64);
            }
        }
        return this;
    }

    public static Buffer insertFromIterator$(Buffer $this, int index, int numberOfValues, Iterator iterator) {
        return $this.insertFromIterator(index, numberOfValues, iterator);
    }

    default public Buffer insertFromIterator(int index, int numberOfValues, Iterator<T> iterator) {
        if (index >= 0 && numberOfValues > 0) {
            int i;
            this.shiftRight(index, numberOfValues);
            for (i = 0; i < numberOfValues && iterator.hasNext(); ++i) {
                this.write(index + i, iterator.next());
            }
            this.touch(index + numberOfValues - 1);
            if (i <= numberOfValues) {
                this.shiftLeft(index + numberOfValues, numberOfValues - i);
            }
        }
        return this;
    }

    public static Buffer insertFromIteratorReverse$(Buffer $this, int index, int numberOfValues, Iterator iterator) {
        return $this.insertFromIteratorReverse(index, numberOfValues, iterator);
    }

    default public Buffer insertFromIteratorReverse(int index, int numberOfValues, Iterator<T> iterator) {
        if (index >= 0 && numberOfValues > 0) {
            int i;
            this.shiftRight(index, numberOfValues);
            for (i = index + numberOfValues - 1; i >= index && iterator.hasNext(); --i) {
                this.write(i, iterator.next());
            }
            this.touch(index + numberOfValues - 1);
            if (i >= index) {
                this.shiftLeft(i + 1, i - index + 1);
            }
        }
        return this;
    }

    public Buffer replaceFromArray(int var1, int var2, int var3, Object var4);

    public Buffer replaceFromSlice(int var1, Slice<T> var2);

    public static Buffer replaceValues$(Buffer $this, int index, int sourceIndex, int numberOfValues, Function1 source) {
        return $this.replaceValues(index, sourceIndex, numberOfValues, source);
    }

    default public Buffer replaceValues(int index, int sourceIndex, int numberOfValues, Function1<Object, T> source) {
        if (index >= 0 && sourceIndex >= 0) {
            if (numberOfValues > 0) {
                this.ensureIndex(index + numberOfValues - 1);
                for (int i = 0; i < numberOfValues; ++i) {
                    this.write(index + i, source.apply((Object)BoxesRunTime.boxToInteger((int)(sourceIndex + i))));
                }
            }
            this.touch(index + numberOfValues - 1);
        }
        return this;
    }

    public static Buffer replaceFromIterator$(Buffer $this, int index, int numberOfValues, Iterator iterator) {
        return $this.replaceFromIterator(index, numberOfValues, iterator);
    }

    default public Buffer replaceFromIterator(int index, int numberOfValues, Iterator<T> iterator) {
        if (index >= 0 && numberOfValues > 0) {
            int i;
            this.ensureIndex(index + numberOfValues - 1);
            for (i = 0; i < numberOfValues && iterator.hasNext(); ++i) {
                this.write(index + i, iterator.next());
            }
            this.touch(index + Math.min(i, numberOfValues) - 1);
        }
        return this;
    }

    public static Buffer replaceFromIteratorReverse$(Buffer $this, int index, int numberOfValues, Iterator iterator) {
        return $this.replaceFromIteratorReverse(index, numberOfValues, iterator);
    }

    default public Buffer replaceFromIteratorReverse(int index, int numberOfValues, Iterator<T> iterator) {
        if (index >= 0 && numberOfValues > 0) {
            this.ensureIndex(index + numberOfValues - 1);
            for (int i = index + numberOfValues - 1; i >= index && iterator.hasNext(); --i) {
                this.write(i, iterator.next());
            }
            this.touch(index + numberOfValues - 1);
        }
        return this;
    }

    public static Buffer remove$(Buffer $this, int index) {
        return $this.remove(index);
    }

    default public Buffer remove(int index) {
        return this.shiftLeft(index + 1, 1);
    }

    public static Buffer removeRange$(Buffer $this, int fromIndex, int toIndex) {
        return $this.removeRange(fromIndex, toIndex);
    }

    default public Buffer removeRange(int fromIndex, int toIndex) {
        return this.shiftLeft(toIndex, toIndex - fromIndex);
    }

    public static Buffer removeWhen$(Buffer $this, Function1 pred) {
        return $this.removeWhen(pred);
    }

    default public Buffer removeWhen(Function1<T, Object> pred) {
        int i = 0;
        while (i < this.length()) {
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(this.read(i)))) {
                this.remove(i);
                continue;
            }
            ++i;
        }
        return this;
    }

    public Buffer shiftRight(int var1, int var2);

    public Buffer shiftLeft(int var1, int var2);

    public Buffer moveRangeRight(int var1, int var2, int var3);

    public Buffer moveRangeLeft(int var1, int var2, int var3);

    public static Buffer swap$(Buffer $this, int first, int second) {
        return $this.swap(first, second);
    }

    default public Buffer swap(int first, int second) {
        if (first >= 0 && second >= 0 && first != second && first < this.length() && second < this.length()) {
            T v = this.read(first);
            this.write(first, this.read(second));
            this.write(second, v);
        }
        return this;
    }

    public Buffer swapRange(int var1, int var2, int var3);

    public static Buffer store$(Buffer $this, Object value) {
        return $this.store(value);
    }

    default public Buffer store(T value) {
        if (this.com$github$arturopala$bufferandslice$Buffer$$topIndex() < 0) {
            this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(0);
        }
        this.write(this.com$github$arturopala$bufferandslice$Buffer$$topIndex(), value);
        return this;
    }

    public static Buffer push$(Buffer $this, Object value) {
        return $this.push(value);
    }

    default public Buffer push(T value) {
        this.update(this.length(), value);
        return this;
    }

    public static Object peek$(Buffer $this) {
        return $this.peek();
    }

    default public T peek() {
        return this.apply(this.com$github$arturopala$bufferandslice$Buffer$$topIndex());
    }

    public static Object peek$(Buffer $this, int offset) {
        return $this.peek(offset);
    }

    default public T peek(int offset) {
        return this.apply(this.com$github$arturopala$bufferandslice$Buffer$$topIndex() - offset);
    }

    public static Option peekOption$(Buffer $this, int offset) {
        return $this.peekOption(offset);
    }

    default public Option<T> peekOption(int offset) {
        return this.get(this.com$github$arturopala$bufferandslice$Buffer$$topIndex() - offset);
    }

    public static Object pop$(Buffer $this) {
        return $this.pop();
    }

    /*
     * WARNING - void declaration
     */
    default public T pop() {
        void var1_1;
        T value = this.peek();
        this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(this.com$github$arturopala$bufferandslice$Buffer$$topIndex() - 1);
        return var1_1;
    }

    public static Iterator iterator$(Buffer $this) {
        return $this.iterator();
    }

    default public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int i;
            private final Buffer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
            }

            public int i() {
                return this.i;
            }

            public void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() <= this.$outer.com$github$arturopala$bufferandslice$Buffer$$topIndex();
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var1_1;
                T value = this.$outer.read(this.i());
                this.i_$eq(this.i() + 1);
                return var1_1;
            }
        };
    }

    public static Iterator reverseIterator$(Buffer $this) {
        return $this.reverseIterator();
    }

    default public Iterator<T> reverseIterator() {
        return new Iterator<T>(this){
            private int i;
            private final Buffer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = $outer.com$github$arturopala$bufferandslice$Buffer$$topIndex();
            }

            public int i() {
                return this.i;
            }

            public void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() >= 0;
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var1_1;
                T value = this.$outer.read(this.i());
                this.i_$eq(this.i() - 1);
                return var1_1;
            }
        };
    }

    public static boolean contains$(Buffer $this, Object value) {
        return $this.contains(value);
    }

    /*
     * WARNING - void declaration
     */
    default public boolean contains(T value) {
        void var3_3;
        boolean result = false;
        for (int i = 0; i < this.length(); ++i) {
            if (!BoxesRunTime.equals(this.read(i), value)) continue;
            result = true;
            i = this.length();
        }
        return (boolean)var3_3;
    }

    public static boolean exists$(Buffer $this, Function1 pred) {
        return $this.exists(pred);
    }

    /*
     * WARNING - void declaration
     */
    default public boolean exists(Function1<T, Object> pred) {
        void var3_3;
        boolean result = false;
        for (int i = 0; i < this.length(); ++i) {
            if (!BoxesRunTime.unboxToBoolean((Object)pred.apply(this.read(i)))) continue;
            result = true;
            i = this.length();
        }
        return (boolean)var3_3;
    }
}

