/*
 * Decompiled with CFR 0.152.
 */
package com.github.apetrelli.gwtintegration.datajpa;

import com.github.apetrelli.gwtintegration.service.CrudService;
import java.io.Serializable;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class AbstractCrudService<T, I extends Serializable, R extends JpaRepository<T, I>>
implements CrudService<T, I> {
    protected R repository;

    public AbstractCrudService(R repository) {
        this.repository = repository;
    }

    public T findOne(I id) {
        return (T)this.repository.findOne(id);
    }

    @Transactional(readOnly=false)
    public T save(T entity) {
        return (T)this.repository.save(entity);
    }

    @Transactional(readOnly=false)
    public void delete(I id) {
        this.repository.delete(id);
    }

    @Transactional(readOnly=false)
    public void deleteAll(Set<T> items) {
        this.repository.delete(items);
    }
}

