/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core.entity.enums;

import com.github.jaemon.dinger.bytetalk.entity.ByteText;
import com.github.jaemon.dinger.core.entity.DingerRequest;
import com.github.jaemon.dinger.core.entity.MsgType;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.dingtalk.entity.DingFeedCard;
import com.github.jaemon.dinger.dingtalk.entity.DingLink;
import com.github.jaemon.dinger.dingtalk.entity.DingMarkDown;
import com.github.jaemon.dinger.dingtalk.entity.DingText;
import com.github.jaemon.dinger.dingtalk.entity.Message;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.utils.DingerUtils;
import com.github.jaemon.dinger.wetalk.entity.WeMarkdown;
import com.github.jaemon.dinger.wetalk.entity.WeNews;
import com.github.jaemon.dinger.wetalk.entity.WeText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public enum MessageSubType {
    TEXT(true){

        @Override
        public MsgType msgType(DingerType dingerType, DingerRequest request) {
            String content = request.getContent();
            boolean atAll = request.isAtAll();
            List<String> phones = request.getPhones();
            if (dingerType == DingerType.DINGTALK) {
                DingText message = new DingText(new DingText.Text(content));
                if (atAll) {
                    message.setAt(new Message.At(true));
                } else if (phones != null && !phones.isEmpty()) {
                    message.setAt(new Message.At(phones));
                }
                return message;
            }
            if (dingerType == DingerType.WETALK) {
                WeText.Text text = new WeText.Text(content);
                WeText weText = new WeText(text);
                if (atAll) {
                    text.setMentioned_mobile_list(Arrays.asList("@all"));
                } else if (phones != null && !phones.isEmpty()) {
                    text.setMentioned_mobile_list(phones);
                }
                return weText;
            }
            if (dingerType == DingerType.BYTETALK) {
                if (atAll) {
                    content = "<at user_id=\"all\">\u6240\u6709\u4eba</at>" + content;
                } else if (!CollectionUtils.isEmpty(phones)) {
                    StringBuilder sb = new StringBuilder();
                    for (String phone : phones) {
                        String[] userIdAndName;
                        if (DingerUtils.isEmpty(phone) || (userIdAndName = phone.split(",")).length != 2) continue;
                        sb.append(String.format("<at user_id=\"%s\">%s</at>", userIdAndName[0], userIdAndName[1]));
                    }
                    content = sb.toString() + content;
                }
                return new ByteText(new ByteText.Content(content));
            }
            throw new DingerException(ExceptionEnum.DINGER_UNSUPPORT_MESSAGE_TYPE_EXCEPTION, new Object[]{dingerType, this.name()});
        }
    }
    ,
    MARKDOWN(true){

        @Override
        public MsgType msgType(DingerType dingerType, DingerRequest request) {
            String content = request.getContent();
            String title = request.getTitle();
            List<String> phones = request.getPhones();
            if (dingerType == DingerType.DINGTALK) {
                DingMarkDown message = new DingMarkDown(new DingMarkDown.MarkDown(title, content));
                if (!phones.isEmpty()) {
                    message.setAt(new Message.At(phones));
                }
                return message;
            }
            if (dingerType == DingerType.WETALK) {
                WeMarkdown.Markdown markdown = new WeMarkdown.Markdown(content);
                WeMarkdown weMarkdown = new WeMarkdown(markdown);
                return weMarkdown;
            }
            throw new DingerException(ExceptionEnum.DINGER_UNSUPPORT_MESSAGE_TYPE_EXCEPTION, new Object[]{dingerType, this.name()});
        }
    }
    ,
    IMAGETEXT(false){

        @Override
        public MsgType msgType(DingerType dingerType, DingerRequest request) {
            if (dingerType == DingerType.DINGTALK) {
                return new DingFeedCard(new ArrayList<DingFeedCard.FeedCard.Link>());
            }
            if (dingerType == DingerType.WETALK) {
                return new WeNews(new ArrayList<WeNews.News.Article>());
            }
            throw new DingerException(ExceptionEnum.DINGER_UNSUPPORT_MESSAGE_TYPE_EXCEPTION, new Object[]{dingerType, this.name()});
        }
    }
    ,
    LINK(false){

        @Override
        public MsgType msgType(DingerType dingerType, DingerRequest request) {
            if (dingerType == DingerType.DINGTALK) {
                return new DingLink();
            }
            throw new DingerException(ExceptionEnum.DINGER_UNSUPPORT_MESSAGE_TYPE_EXCEPTION, new Object[]{dingerType, this.name()});
        }
    };

    private boolean support;

    private MessageSubType(boolean support) {
        this.support = support;
    }

    public boolean isSupport() {
        return this.support;
    }

    public abstract MsgType msgType(DingerType var1, DingerRequest var2);

    public static boolean contains(String value) {
        return Arrays.stream(MessageSubType.values()).filter(e -> Objects.equals(e.name(), value)).count() > 0L;
    }
}

